package com.bxm.localnews.admin.service.news;

import com.bxm.localnews.admin.param.NewsKindParam;
import com.bxm.localnews.admin.vo.NewsKind;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * @author zhaoyadong 2019/2/15 11:49
 * @desc
 */
public interface NewsKindService {

    /**
     * 查询新闻频道
     * @param param 频道参数
     * @return 分页结果
     */
    PageWarper<NewsKind> queryNewsKinds(NewsKindParam param);

    /**
     * 获取新闻频道详情
     * @param id
     * @return
     */
    NewsKind selectByPrimaryKey(Long id);

    /**
     * 新闻频道上下架
     * @param id
     * @param status
     * @return 更新信息
     */
    int updateNewsKindStatus(Long id, Byte status);

    /**
     * 新增或编辑新闻频道
     * @param newsKind
     * @return
     */
    int addNewsKind(NewsKind newsKind);
}
