package com.bxm.localnews.admin.service.news.impl;

import com.bxm.localnews.admin.domain.VirtualUserMapper;
import com.bxm.localnews.admin.param.NewsReplyOriginalParam;
import com.bxm.localnews.admin.param.NewsReplyParam;
import com.bxm.localnews.admin.service.news.AdminNewsReplyService;
import com.bxm.localnews.admin.vo.NewsReply;
import com.bxm.localnews.admin.vo.VirtualUser;
import com.bxm.localnews.news.domain.NewsMapper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.domain.UserReplyMapper;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.PageWarper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class AdminNewsReplyServiceImpl extends BaseService implements AdminNewsReplyService {

    @Autowired
    private VirtualUserMapper virtualUserMapper;

    @Autowired
    private NewsReplyMapper newsReplyMapper;

    @Autowired
    private NewsMapper newsMapper;

    @Autowired
    private UserReplyMapper userReplyMapper;

    @Override
    public void doGenerateReply(NewsReplyOriginalParam newsReplyOriginalParam) {
        List<VirtualUser> virtualUserList =virtualUserMapper.selectByModel();
        if (CollectionUtils.isEmpty(virtualUserList)) {
            return ;
        }
        int userSize = virtualUserList.size();

        long startTime = newsReplyOriginalParam.getStartTime().getTime();
        long endTime = newsReplyOriginalParam.getEndTime().getTime();
        long currentTime = System.currentTimeMillis();
        long size = newsReplyOriginalParam.getList().size();
        long interval = (endTime-startTime)/size;
        long indexTime =startTime;

        List<NewsReplyOriginalParam.Reply> replyList = newsReplyOriginalParam.getList();
        for (NewsReplyOriginalParam.Reply reply:replyList) {
            int index = (int) (Math.random()* userSize);
            VirtualUser virtualUser = virtualUserList.get(index);
            indexTime = indexTime + interval;
            NewsReply newsReply = new NewsReply();
            newsReply.setAddTime(new Date(indexTime));
            newsReply.setDeleteFlag((byte) 0);
            newsReply.setHeadImg(virtualUser.getHeadImg());
            newsReply.setId(nextSequence());
            newsReply.setLevel((byte) 0);
            newsReply.setLikeCount(0);
            newsReply.setNewsId(newsReplyOriginalParam.getNewsId());
            newsReply.setReplyContent(reply.getContent());
            newsReply.setType((byte) 1);
            newsReply.setParentId(0L);
            //待展示
            newsReply.setStatus((byte) 0);
            if (indexTime<=currentTime) {
                newsReply.setStatus((byte) 1);
            }
            newsReply.setUserId(virtualUser.getId());
            newsReply.setUserNickname(virtualUser.getNickname());
            newsReply.setInteractiveCount(0);
            newsReply.setRootId(0L);
            newsReplyMapper.insertSelective(newsReply);
            userReplyMapper.insertUserReplySelective(newsReply);
        }

        int count = newsReplyMapper.count(newsReplyOriginalParam.getNewsId());
        newsMapper.updateComment(newsReplyOriginalParam.getNewsId(),count);
    }

    @Override
    public void delReply(Long id,Long newsId) {
        NewsReply newsReply = newsReplyMapper.selectByPrimaryKey(id, newsId);
        if (newsReply != null) {
            newsReplyMapper.deleteByPrimaryKey(id, newsId);
            userReplyMapper.deleteUserReplyByPrimaryKey(id,newsReply.getUserId());

            int count = newsReplyMapper.count(newsId);
            newsMapper.updateComment(newsId, count);
        }

    }

    @Override
    public PageWarper<NewsReply> listNewsReply(NewsReplyParam newsReplyParam) {
        return new PageWarper<>(newsReplyMapper.queryByPageSize(newsReplyParam));
    }
}
