package com.bxm.localnews.admin.service.news.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.admin.config.BizConfigProperties;
import com.bxm.localnews.admin.constant.MarketingActivitiesDeliveryTypeEnum;
import com.bxm.localnews.admin.constant.NewsAreaRelationTypeEnum;
import com.bxm.localnews.admin.constant.NewsStatusEnum;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.AreaCodeMapper;
import com.bxm.localnews.admin.domain.AreaDivisionMapper;
import com.bxm.localnews.admin.dto.ContentDTO;
import com.bxm.localnews.admin.dto.ESNewsContentDTO;
import com.bxm.localnews.admin.dto.LocationDTO;
import com.bxm.localnews.admin.dto.NewsDTO;
import com.bxm.localnews.admin.enums.ShowLevelEnum;
import com.bxm.localnews.admin.param.*;
import com.bxm.localnews.admin.seq.NewsSeqComponent;
import com.bxm.localnews.admin.service.NewsElasticService;
import com.bxm.localnews.admin.service.NewsSyncService;
import com.bxm.localnews.admin.service.QuartzIntegrationService;
import com.bxm.localnews.admin.service.SpiderManageService;
import com.bxm.localnews.admin.service.base.LocationService;
import com.bxm.localnews.admin.service.news.AdminNewsService;
import com.bxm.localnews.admin.service.news.CommonTagService;
import com.bxm.localnews.admin.service.recommend.MixRecommendPoolService;
import com.bxm.localnews.admin.vo.*;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.domain.*;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.Page;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

import static com.bxm.localnews.admin.enums.ShowLevelEnum.LOCAL;

/**
 * @author zhaoyadong 2018/10/16 9:22
 * @desc
 */
@Service
@RefreshScope
public class AdminNewsServiceImpl implements AdminNewsService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private NewsSeqComponent newsSeqComponent;

    private NewsDeliveryAreaMapper newsDeliveryAreaMapper;

    private NewsKindMapper kindMapper;

    private CommonTagService commonTagService;

    private NewsTagMapper newsTagMapper;

    private NewsStatisticsMapper newsStatisticsMapper;

    private AdminNewsMapper adminNewsMapper;

    private BizConfigProperties bizConfigProperties;

    private NewsElasticService newsElasticService;

    private NewsSyncService newsSyncService;

    private AreaCodeMapper areaCodeMapper;

    private RedisStringAdapter redisStringAdapter;

    private QuartzIntegrationService quartzIntegrationService;

    private SpiderManageService spiderManageService;

    private AreaDivisionMapper areaDivisionMapper;

    private LocationService locationService;

    private  MixedRecommendPoolMapper mixedRecommendPoolMapper;

    private  ForumPostMapper forumPostMapper;


    private MixRecommendPoolService mixRecommendPoolService;

    @Autowired(required = false)
    public AdminNewsServiceImpl(AdminNewsMapper adminNewsMapper, BizConfigProperties bizConfigProperties,
                                NewsElasticService newsElasticService, NewsSeqComponent newsSeqComponent,
                                NewsDeliveryAreaMapper newsDeliveryAreaMapper, NewsKindMapper kindMapper,
                                CommonTagService commonTagService, NewsTagMapper newsTagMapper,
                                NewsStatisticsMapper newsStatisticsMapper, NewsSyncService newsSyncService,
                                AreaCodeMapper areaCodeMapper, RedisStringAdapter redisStringAdapter,
                                SpiderManageService spiderManageService,
                                AreaDivisionMapper areaDivisionMapper,
                                QuartzIntegrationService quartzIntegrationService,
                                LocationService locationService,
                                MixedRecommendPoolMapper mixedRecommendPoolMapper,
                                ForumPostMapper forumPostMapper,
                                MixRecommendPoolService mixRecommendPoolService) {
        this.adminNewsMapper = adminNewsMapper;
        this.bizConfigProperties = bizConfigProperties;
        this.newsElasticService = newsElasticService;
        this.newsSeqComponent = newsSeqComponent;
        this.newsDeliveryAreaMapper = newsDeliveryAreaMapper;
        this.kindMapper = kindMapper;
        this.commonTagService = commonTagService;
        this.newsTagMapper = newsTagMapper;
        this.newsStatisticsMapper = newsStatisticsMapper;
        this.newsSyncService = newsSyncService;
        this.areaCodeMapper = areaCodeMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.quartzIntegrationService = quartzIntegrationService;
        this.spiderManageService = spiderManageService;
        this.areaDivisionMapper = areaDivisionMapper;
        this.locationService = locationService;
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
        this.forumPostMapper = forumPostMapper;
        this.mixRecommendPoolService = mixRecommendPoolService;
    }


    @Override
    public PageWarper<NewsOverView> queryNews(NewsParam newsParam) {
        logger.info("NewsParam:{}", JSON.toJSON(newsParam));
        AdminNewsPageParam adminNewsPageParam = new AdminNewsPageParam();
        BeanUtils.copyProperties(newsParam, adminNewsPageParam);
        adminNewsPageParam.setKeyword(newsParam.getTitle());
        adminNewsPageParam.setAreaCode(newsParam.getAreaName());
        NewsDTO pageWarper = newsElasticService.listNews(adminNewsPageParam).getBody();

        List<NewsOverView> newsDtoList = new ArrayList<>();
        if (null != pageWarper) {
            List<com.bxm.localnews.admin.dto.News> newsList = pageWarper.getNewsList();
            String h5ServerHost = bizConfigProperties.getH5ServerHost();

            for (com.bxm.localnews.admin.dto.News news : newsList) {
                NewsOverView newsDto = new NewsOverView();

                //todo 这里要做个缓存，每次都去数据库取肯定不行 [沈涛]
                if (null != news.getAreaDetail()) {
                    List<AreaCode> areaCodeList = areaCodeMapper.findListByCode(news.getAreaDetail());
                    newsDto.setAreaDetail(JSONObject.toJSONString(areaCodeList));
                }

                if (news.getType() == 1 || news.getType() == 3) {
                    newsDto.setLinkUrl(h5ServerHost + "/newsDetail.html?newsId=" + news.getId() + "&userId=" + "&type="
                            + news.getType());
                }

                this.fillingShowLevelDetail(news, newsDto);
                this.convertNews(news, newsDto);



                newsDtoList.add(newsDto);
            }
        }
        com.github.pagehelper.Page page = new Page(newsParam.getPageNum(), newsParam.getPageSize());
        page.setTotal(pageWarper.getTotal());
        page.addAll(newsDtoList);
        return new PageWarper<>(page);
    }

    private void fillingShowLevelDetail(com.bxm.localnews.admin.dto.News news, NewsOverView newsDto) {
        List<String> showLevelDetail = new ArrayList();
        // todo 魔法值定义[沈涛]
        if (news.getTop() == 2) {
            showLevelDetail.add("0");
        }
        if (news.getHot() == 2) {
            showLevelDetail.add("1");
        }
        if (news.getKindTop() != null && news.getKindTop() == 2) {
            showLevelDetail.add("2");
        }
        if (news.getHot() == 3) {
            showLevelDetail.add("3");
        }

        if (null != news.getAreaDetail()) {
            showLevelDetail.add("4");
        }
        if (CollectionUtils.isEmpty(showLevelDetail)) {
            showLevelDetail.add("99");
        }

        newsDto.setShowLevelDetail(StringUtils.join(showLevelDetail, ","));


    }

    private void fillingShowLevelDetail(News news) {
        List<String> showLevelDetail = new ArrayList();
        // todo 魔法值定义[沈涛]
        if (news.getTop() == 2) {
            showLevelDetail.add("0");
        }
        if (news.getHot() == 2) {
            showLevelDetail.add("1");
        }
        if (news.getKindTop() != null && news.getKindTop() == 2) {
            showLevelDetail.add("2");
        }

        if (news.getHot() == 3) {
            showLevelDetail.add("3");
        }

        if (null != news.getAreaDetail()) {
            showLevelDetail.add("4");
        }
        if (CollectionUtils.isEmpty(showLevelDetail)) {
            showLevelDetail.add("99");
        }
        news.setShowLevelDetail(StringUtils.join(showLevelDetail, ","));

    }

    private void convertNews(com.bxm.localnews.admin.dto.News news, NewsOverView newsDto) {
        newsDto.setAddTime(news.getAddTime());
        newsDto.setId(Long.valueOf(news.getId()));
        newsDto.setIssueTime(news.getIssueTime());
        newsDto.setKindId(news.getKindId());
        newsDto.setPublishTime(news.getPublishTime());
        newsDto.setStatus((byte) news.getStatus().intValue());
        newsDto.setTitle(news.getTitle());
        newsDto.setType(news.getType());
        newsDto.setReviewStatus(news.getReviewStatus());
        newsDto.setAuthor(news.getAuthor());

    }

    @Override
    public int updateByPrimaryKeySelective(News news) {
        return this.adminNewsMapper.updateByPrimaryKeySelective(news);
    }

    @Override
    public int updateNewsStatusByIds(String[] ids, Byte status) {
        return this.adminNewsMapper.updateNewsStatusByIds(ids, status);
    }

    @Override
    public int updateNewsReviewStatusByIds(String[] ids, Byte review) {
        return this.adminNewsMapper.updateNewsReviewStatusByIds(ids, review);
    }

    @Override
    public News selectByPrimaryKey(Long id) {
        News news = this.adminNewsMapper.selectByPrimaryKey(id);
        if (news == null) {
            return null;
        }
        logger.debug("新闻详情es开始拉取 ");
        ResponseEntity<List<ESNewsContentDTO>> responseEntity = newsElasticService.multipleGet(new Long[]{news.getId()});
        if (responseEntity == null || responseEntity.getStatusCode().isError() || responseEntity.getBody().isEmpty()) {
            logger.debug("新闻详情es拉取失败:{}", responseEntity.getBody());

            // return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "获取详情时新闻缺失");
            return null;
        }
        if (null != news.getAreaDetail()) {
            String[] areaCodeArray = news.getAreaDetail().split(",");
            List<AreaCode> areaCodeList = areaCodeMapper.findListByCode(areaCodeArray);
            news.setAreaDetail(JSONObject.toJSONString(areaCodeList));
            news.setDeliveryType(1);
        } else {
            news.setDeliveryType(0);
        }

        this.fillingShowLevelDetail(news);

        news.setContent(responseEntity.getBody().get(0).getContent());
        logger.debug("新闻详情拉取完成：{}", responseEntity.getBody());
        String h5ServerHost = bizConfigProperties.getH5ServerHost();
        if (news.getType() == 1 || news.getType() == 3) {
            news.setLinkUrl(h5ServerHost + "/newsDetail.html?newsId=" + news.getId() + "&userId=" + "&type="
                    + news.getType());
        }

        return news;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Json addNews(NewsAddParam newsParam) {
        News news = new News();
        if (null != newsParam.getId()) {
            news.setId(newsParam.getId());
        } else {
            news.setId(newsSeqComponent.getNewsId());
        }
        news.setTitle(newsParam.getTitle());
        news.setContent(newsParam.getContent());
        news.setAddTime(Calendar.getInstance().getTime());
        news.setIssueTime(newsParam.getIssueTime());
        news.setPublishTime(newsParam.getPublishTime());
        news.setStatus(NewsStatusEnum.UNPUBLISHED.getCode());
        news.setDeliveryType(newsParam.getDeliveryType());
        news.setAddress("null");
        news.setType((byte) 1);
        news.setAuthor(newsParam.getAuthor());
        news.setKindId(newsParam.getKindId());
        news.setReviewStatus((byte) 2);

        List<NewsKind> kindList = kindMapper.selectAllKinds();
        Optional<NewsKind> newsKind = kindList.stream().filter(kind -> kind.getId().intValue() == news.getKindId()).findFirst();
        newsKind.ifPresent(kindName -> news.setKindName(kindName.getName()));

        if (StringUtils.isNotBlank(newsParam.getCoverUrl())) {
            news.setImgUrl(JSON.toJSONString(newsParam.getCoverUrl().split(",")));
        } else {
            news.setImgUrl("");
        }

        // 判断热文
        logger.debug("判断热门:{}", newsParam.getHot() == 2);

        news.setHot(newsParam.getHot());
        if (newsParam.getHot() == 2) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(newsParam.getIssueTime());
            calendar.add(Calendar.HOUR, 24);
            news.setHotExpireTime(calendar.getTime());
        }

        news.setKindTop((byte) 1);
        if (newsParam.getKindTop() != null) {
            news.setKindTop(newsParam.getKindTop());
        }

        news.setTop(newsParam.getTop());
        if (newsParam.getTop() == 2 || newsParam.getKindId() == 2) {
            news.setTopExpireTime(newsParam.getTopExpireTime());
        }

        // 投放为区域型
        if (MarketingActivitiesDeliveryTypeEnum.AREA.getCode().equals(newsParam.getDeliveryType())) {
            if (StringUtils.isNotBlank(newsParam.getAreaCodes())) {
                news.setAreaDetail(newsParam.getAreaCodes());
            } else {
                return ResultUtil.genFailedResult("投放区域入参错误");
            }
        }
        logger.debug("判断热门:{}", newsParam.getHot() == 2);
        this.newsSyncService.save(news);

        // 创建发布新闻job并清除首页置顶新闻列表缓存
        this.createPublishNewsTaskJob(news, newsParam.getAreaCodes());

        // 清除首页置顶新闻列表缓存
        this.clearRedisCacheOfTopNewsList(newsParam.getAreaCodes(), null);

        return ResultUtil.genSuccessResult();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Json updateNews(NewsUpdateParam newsUpdateParam) {
        News news = adminNewsMapper.selectByPrimaryKey(newsUpdateParam.getId());
        if (news == null) {
            return ResultUtil.genFailedResult("新闻不存在");
        }

        News param = new News();
        param.setContent(newsUpdateParam.getContent());
        param.setId(news.getId());
        param.setTitle(newsUpdateParam.getTitle());
        param.setReviewStatus(newsUpdateParam.getReviewStatus());
        param.setStatus(newsUpdateParam.getStatus());
        param.setAuthor(newsUpdateParam.getAuthor());
        param.setKindId(newsUpdateParam.getKindId());
        if (StringUtils.isNotBlank(newsUpdateParam.getCoverUrl())) {
            param.setImgUrl(JSON.toJSONString(newsUpdateParam.getCoverUrl().split(",")));
        }
        param.setIssueTime(newsUpdateParam.getIssueTime());
        param.setPublishTime(newsUpdateParam.getPublishTime());
        // if (news.getStatus() == NewsStatusEnum.UNPUBLISHED.getCode()) {
        if (StringUtils.isNotBlank(newsUpdateParam.getAreaCodes())) {
            param.setAreaDetail(newsUpdateParam.getAreaCodes());
        } else {
            param.setAreaDetail(null);
        }
        // 创建发布新闻job ,在更新爬过来的新闻时，不需要定时发布新闻
        if (news.getPublishTime() != null) {
            this.createPublishNewsTaskJob(news, newsUpdateParam.getAreaCodes());
        }
        // }

        param.setTop(newsUpdateParam.getTop());
        param.setKindTop(newsUpdateParam.getKindTop());
        if (newsUpdateParam.getKindTop() == 2 || newsUpdateParam.getTop() == 2) {
            param.setTopExpireTime(newsUpdateParam.getTopExpireTime());
        }
        param.setHot(newsUpdateParam.getHot());
        if (newsUpdateParam.getHot() == 2) {
            if (news.getHotExpireTime() == null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(newsUpdateParam.getIssueTime());
                calendar.add(Calendar.HOUR, 24);
                param.setHotExpireTime(calendar.getTime());
            }

        }

        this.newsSyncService.save(param);

        //更新推荐池内容

        MixedRecommendPool mixedRecommendPool = new MixedRecommendPool();
        mixedRecommendPool.setId(param.getId());
        mixedRecommendPool.setTitle(param.getTitle());
        mixedRecommendPool.setIssueTime(param.getIssueTime());
        if (StringUtils.isNotBlank(newsUpdateParam.getAreaCodes())) {
            mixedRecommendPool.setAreaDetail(newsUpdateParam.getAreaCodes());
        } else {
            mixedRecommendPool.setAreaDetail(null);
        }
        mixedRecommendPool.setOrigin("2");
        mixRecommendPoolService.updateMixRecommend(mixedRecommendPool);
        // 清除首页置顶新闻列表缓存
        this.clearRedisCacheOfTopNewsList(newsUpdateParam.getAreaCodes(), news.getAreaDetail());
        return ResultUtil.genSuccessResult();
    }

    private void saveDelivery(News news, List<AreaCode> areaCodeList, List<String> areaCodeStrList, Optional<AreaDivision> areaDivisionOptional) {
        if (areaDivisionOptional.isPresent()) {
            List<LocationDTO> locationDTOList = locationService.listOpenedLocationByAreaWithTwoLevels(areaDivisionOptional.get().getCode(), (byte) 1);
            locationDTOList = locationDTOList.stream().filter(x -> !x.getCode().equals(areaDivisionOptional.get().getCode())).collect(Collectors.toList());
            for (LocationDTO locationDTO : locationDTOList) {
                NewsDeliveryArea area = new NewsDeliveryArea();
                AreaCode areaCode = new AreaCode();
                areaCode.setAreaCode(locationDTO.getCode());
                areaCode.setAreaName(locationDTO.getName());
                area.setAreaCode(locationDTO.getCode());
                area.setAreaName(locationDTO.getName());
                area.setCreateTime(Calendar.getInstance().getTime());
                area.setBusinessId(news.getId());
                area.setRelationType(NewsAreaRelationTypeEnum.NEWS.getCode());
                newsDeliveryAreaMapper.save(area);
                areaCodeList.add(areaCode);
            }
        } else {
            for (String code : areaCodeStrList) {
                NewsDeliveryArea area = new NewsDeliveryArea();
                AreaCode areaCode = areaCodeMapper.findByCode(code);
                area.setAreaCode(code);
                area.setAreaName(areaCode.getAreaName());
                area.setCreateTime(Calendar.getInstance().getTime());
                area.setBusinessId(news.getId());
                area.setRelationType(NewsAreaRelationTypeEnum.NEWS.getCode());
                newsDeliveryAreaMapper.save(area);
                areaCodeList.add(areaCode);
            }
        }
    }

    /**
     * @param param
     * @Description 方法描述：如果选择区域就将新闻展示类型设为本地
     * @author leon 2019年1月16日 下午2:34:33
     * @CopyRight 杭州微财网络科技有限公司
     */
    private void setLocalTag(News param) {
        if ((StringUtils.isNotBlank(param.getShowLevelDetail())
                && param.getShowLevelDetail().contains(LOCAL.getCode() + ""))
                || StringUtils.isBlank(param.getAreaDetail())) {
            return;
        }
        if (ShowLevelEnum.NORMAL.getCode().equals(param.getShowLevel())) {
            param.setShowLevel(LOCAL.getCode());
            param.setShowLevelDetail(LOCAL.getCode().toString());
        } else {
            param.setShowLevelDetail(param.getShowLevelDetail() + "," + LOCAL.getCode());
        }
    }

    @Override
    public List<NewsKind> getAllKind() {
        return kindMapper.selectAllKinds();
    }

    @Override
    public Json settingLevel(ShowLevelEnum showLevelEnum, Long id) {
        News news = adminNewsMapper.selectByPrimaryKey(id);
        if (news == null) {
            return ResultUtil.genFailedResult("新闻不存在");
        }
        News param = new News();
        if (StringUtils.isNotBlank(news.getShowLevelDetail())) {
            String[] levels = StringUtils.split(news.getShowLevelDetail(), ",");
            List<String> levelList = new ArrayList<>(Arrays.asList(levels));
            if (!levelList.contains(showLevelEnum.getCode() + "")) {
                levelList.add(showLevelEnum.getCode() + "");
            }
            Collections.sort(levelList);
            param.setId(id);
            param.setShowLevel(Integer.parseInt(levelList.get(0)));
            param.setShowLevelDetail(StringUtils.join(levelList, ","));
            adminNewsMapper.updateByPrimaryKeySelective(param);
        } else {
            param.setId(id);
            param.setShowLevel(showLevelEnum.getCode());
            param.setShowLevelDetail(showLevelEnum.getCode() + "");
            adminNewsMapper.updateByPrimaryKeySelective(param);
        }
        return ResultUtil.genSuccessResult();
    }

    @Override
    public ContentDTO getSpiderContent(CrawlingParam param) {
        ResponseEntity<ContentDTO> contentDTOResponseEntity = spiderManageService.pageDownload(param);
        return contentDTOResponseEntity.getBody();
    }

    @Override
    public void review(Long id, Byte review) {
        News news = adminNewsMapper.selectByPrimaryKey(id);
        News newsParam = new News();
        newsParam.setId(id);
        newsParam.setTop(news.getTop());
        newsParam.setHot(news.getHot());
        newsParam.setKindTop(news.getKindTop());
        newsParam.setKindId(news.getKindId());
        newsParam.setReviewStatus(review);
        newsParam.setStatus(news.getStatus());
        newsParam.setHotExpireTime(news.getHotExpireTime());
        newsParam.setIssueTime(news.getIssueTime());
        newsParam.setTopExpireTime(news.getTopExpireTime());
        newsParam.setAreaDetail(news.getAreaDetail());
        newsSyncService.save(newsParam);
    }

    @Override
    public void batchReview(String ids, Byte review) {
        String[] idArray = ids.split(",");
        if (idArray.length > 0) {
            for (String idStr : idArray) {

                News news = adminNewsMapper.selectByPrimaryKey(Long.valueOf(idStr));
                News newsParam = new News();
                newsParam.setId(Long.valueOf(idStr));
                newsParam.setTop(news.getTop());
                newsParam.setHot(news.getHot());
                newsParam.setKindTop(news.getKindTop());
                newsParam.setKindId(news.getKindId());
                newsParam.setReviewStatus(review);
                newsParam.setStatus(news.getStatus());
                newsParam.setHotExpireTime(news.getHotExpireTime());
                newsParam.setIssueTime(news.getIssueTime());
                newsParam.setTopExpireTime(news.getTopExpireTime());
                newsParam.setAreaDetail(news.getAreaDetail());
                newsSyncService.save(newsParam);

            }
        }
    }

    @Override
    public Long getCreateId() {
        return newsSeqComponent.getNewsId();
    }


    /**
     * @param newAreaCodeStr
     * @param oldAreaCodeStr
     * @Description 方法描述：清除首页置顶新闻列表缓存
     * @author leon 2019年1月15日 下午5:10:00
     * @CopyRight 杭州微财网络科技有限公司
     */
    private void clearRedisCacheOfTopNewsList(String newAreaCodeStr, String oldAreaCodeStr) {
        // 删除更新后的地区置顶新闻缓存
        if (StringUtils.isNotEmpty(newAreaCodeStr)) {
            String[] areaCodes = newAreaCodeStr.split(",");
            for (String areaCode : areaCodes) {
                KeyGenerator keyGenerator = RedisConfig.TOP_NEW_OF_AREA_LIST.copy().appendKey(areaCode);
                redisStringAdapter.remove(keyGenerator);
            }
        }
        // 删除更新前的地区置顶新闻缓存
        if (StringUtils.isNotEmpty(oldAreaCodeStr)) {
            String[] areaCodes = oldAreaCodeStr.split(",");
            for (String obj : areaCodes) {
                KeyGenerator keyGenerator = RedisConfig.TOP_NEW_OF_AREA_LIST.copy().appendKey(obj);
                redisStringAdapter.remove(keyGenerator);
            }
        }
        // 清除全国性置顶新闻缓存
        redisStringAdapter.remove(RedisConfig.TOP_NEW_OF_WHOLE_COUNTRY_LIST);
    }

    /**
     * @param news
     * @Description 方法描述：创建发布新闻job
     * @author leon 2019年1月16日 下午1:48:20
     * @CopyRight 杭州微财网络科技有限公司
     */
    private void createPublishNewsTaskJob(News news, String areaCodes) {
        PublishNewsBuildParam param = new PublishNewsBuildParam();
        param.setAreaCodes(areaCodes);
        param.setNewsId(news.getId());
        param.setStartTime(news.getPublishTime());
        logger.debug("创建发布新闻:{}", JSON.toJSONString(param));
        quartzIntegrationService.addPublish(param);
    }




    @Override
    public int addNewsToMixRecommendPool(MixPoolParam mixPoolParam) {
        MixedRecommendPool mixedRecommendPool = new MixedRecommendPool();

        String origin = mixPoolParam.getOrigin();
        if (StringUtils.equals("2",origin)|| StringUtils.equals("3",origin) ){
            News news = adminNewsMapper.selectByPrimaryKey(mixPoolParam.getId());
            BeanUtils.copyProperties(news,mixedRecommendPool);
            //更新新闻为以推荐
            News newsTotle = new News();
            newsTotle.setId(mixPoolParam.getId());
            //将新闻设置为推荐
            newsTotle.setIsRecommend((byte)1);
            adminNewsMapper.updateByPrimaryKeySelective(newsTotle);
        }else if (StringUtils.equals("1",origin)){
            ForumPost forumPost = forumPostMapper.selectByPrimaryKey(mixPoolParam.getId());
            mixedRecommendPool.setTitle(forumPost.getTitle());
            mixedRecommendPool.setAreaDetail(forumPost.getAreaCode());
            mixedRecommendPool.setIssueTime(forumPost.getDisplayTime());
            mixedRecommendPool.setId(forumPost.getId());
        }
        Date currentTime = new Date();
        mixedRecommendPool.setOrigin(origin);
        mixedRecommendPool.setAddTime(currentTime);
        mixedRecommendPool.setModifyTime(currentTime);
        mixedRecommendPool.setWeight(0);
        mixedRecommendPool.setTop((byte)1);
        mixedRecommendPool.setStatus((byte)1);
        int result = mixedRecommendPoolMapper.insertSelective(mixedRecommendPool);
        return result;
    }

    @Override
    public int deleteNewsById(Long id) {
        News news = new News();
        news.setId(id);
        //将新闻的状态设置为-2 表示已删除
        news.setStatus((byte) -2);
        int result = adminNewsMapper.updateByPrimaryKeySelective(news);
        MixedRecommendPoolExample example = new MixedRecommendPoolExample();
        example.createCriteria().andIdEqualTo(id);
        mixedRecommendPoolMapper.deleteByExample(example);
        return result;
    }

}
