package com.bxm.localnews.admin.service.news.impl;

import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.param.NewsKindParam;
import com.bxm.localnews.admin.service.news.NewsKindService;
import com.bxm.localnews.admin.vo.NewsKind;
import com.bxm.localnews.news.domain.NewsKindMapper;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/2/15 11:58
 * @desc
 */
@Service
public class NewsKindServiceImpl implements NewsKindService {

    private NewsKindMapper newsKindMapper;

    private SequenceCreater sequenceCreater;

    private RedisStringAdapter redisStringAdapter;

    @Autowired
    public NewsKindServiceImpl(NewsKindMapper newsKindMapper, SequenceCreater sequenceCreater,
                               RedisStringAdapter redisStringAdapter) {
        this.newsKindMapper = newsKindMapper;
        this.sequenceCreater = sequenceCreater;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public PageWarper<NewsKind> queryNewsKinds(NewsKindParam param) {
        return new PageWarper<>(newsKindMapper.queryKinds(param));
    }

    @Override
    public NewsKind selectByPrimaryKey(Long id) {
        return newsKindMapper.selectByPrimaryKey(id);
    }

    @Override
    public int updateNewsKindStatus(Long id, Byte status) {
        NewsKind newsKind = this.newsKindMapper.selectByPrimaryKey(id);
        if (newsKind == null) {
            return 0;
        }
        newsKind.setStatus(status);
        this.newsKindMapper.updateByPrimaryKeySelective(newsKind);
        removeCache();

        return 1;
    }

    @Override
    public int addNewsKind(NewsKind newsKind) {
        Long kindId = newsKind.getId();
        if (kindId == null) {
            kindId = sequenceCreater.nextLongId();
        }

        int update;
        if (newsKind.getId() == null) {
            newsKind.setId(kindId);
            update = this.newsKindMapper.insertSelective(newsKind);
        } else {
            update = this.newsKindMapper.updateByPrimaryKeySelective(newsKind);
        }

        removeCache();

        return update;
    }


    /**
     * 获取频道类列表的key
     * @return
     */
    private KeyGenerator getNewsKindKey() {
        return RedisConfig.NEWS_KIND.copy();
    }

    /**
     * 移除缓存
     */
    private void removeCache() {
        redisStringAdapter.remove(this.getNewsKindKey());
    }
}
