package com.bxm.localnews.admin.service.news.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.admin.constant.NewsStatusEnum;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.param.NewsBlackParam;
import com.bxm.localnews.admin.service.NewsSyncService;
import com.bxm.localnews.admin.service.news.NewsService;
import com.bxm.localnews.admin.vo.AreaCode;
import com.bxm.localnews.admin.vo.GlobalNewsBlackEntity;
import com.bxm.localnews.admin.vo.News;
import com.bxm.localnews.news.domain.AdminNewsBlackMapper;
import com.bxm.localnews.news.domain.AdminNewsMapper;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.vo.PageWarper;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Calendar;
import java.util.List;

@Service
public class NewsServiceImpl implements NewsService {

    private RedisListAdapter redisListAdapter;

    private AdminNewsMapper adminNewsMapper;

    private AdminNewsBlackMapper adminNewsBlackMapper;

    private RedisStringAdapter redisStringAdapter;

    private NewsSyncService newsSyncService;

    @Autowired
    public NewsServiceImpl(AdminNewsMapper adminNewsMapper, AdminNewsBlackMapper adminNewsBlackMapper,
                           RedisListAdapter redisListAdapter, RedisStringAdapter redisStringAdapter,
                           NewsSyncService newsSyncService) {
        this.adminNewsMapper = adminNewsMapper;
        this.adminNewsBlackMapper = adminNewsBlackMapper;
        this.redisListAdapter = redisListAdapter;
        this.redisStringAdapter = redisStringAdapter;
        this.newsSyncService = newsSyncService;
    }

    @Override
    public PageWarper<News> selectByTitleAndStatus(NewsBlackParam param) {
        return new PageWarper<>(adminNewsMapper.selectByTitleAndStatus(param), 10);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void addNewsBlack(Long newsId, String remark) {
        GlobalNewsBlackEntity entity = new GlobalNewsBlackEntity();
        entity.setCreateTime(Calendar.getInstance().getTime());
        entity.setRemark(remark);
        entity.setType(0);// 无意义缺省值
        entity.setNewsId(newsId);
        adminNewsBlackMapper.insert(entity);

        News news = adminNewsMapper.selectByPrimaryKey(newsId);
        News newsParam = new News();
        newsParam.setId(newsId);
        newsParam.setTop(news.getTop());
        newsParam.setHot(news.getHot());
        newsParam.setKindTop(news.getKindTop());
        newsParam.setKindId(news.getKindId());
        newsParam.setReviewStatus(news.getReviewStatus());
        newsParam.setStatus(NewsStatusEnum.DISABLE.getCode());
        newsParam.setHotExpireTime(news.getHotExpireTime());
        newsParam.setTopExpireTime(news.getTopExpireTime());
        newsParam.setAreaDetail(news.getAreaDetail());
        newsSyncService.save(newsParam);

//        adminNewsMapper.updateNewsStatusByIds(new String[]{newsId + ""}, NewsStatusEnum.DISABLE.getCode());
        redisListAdapter.leftTrim(RedisConfig.NEWS_BLACK.copy(), 1, 0);
        // 清除首页置顶新闻列表缓存
        this.clearRedisCacheOfTopNewsList(news.getAreaDetail(),null);
    }

    @Transactional
    @Override
    public void delNewsBlack(Long newsId) {
        adminNewsBlackMapper.deleteByNewsId(newsId);

        News news = adminNewsMapper.selectByPrimaryKey(newsId);
        News newsParam = new News();
        newsParam.setTop(news.getTop());
        newsParam.setId(newsId);
        newsParam.setHot(news.getHot());
        newsParam.setKindTop(news.getKindTop());
        newsParam.setKindId(news.getKindId());
        newsParam.setReviewStatus(news.getReviewStatus());
        newsParam.setStatus(NewsStatusEnum.ENABLE.getCode());
        newsParam.setHotExpireTime(news.getHotExpireTime());
        newsParam.setTopExpireTime(news.getTopExpireTime());
        newsParam.setAreaDetail(news.getAreaDetail());
        newsSyncService.save(newsParam);

//        adminNewsMapper.updateNewsStatusByIds(new String[]{newsId + ""}, NewsStatusEnum.ENABLE.getCode());
        redisListAdapter.leftTrim(RedisConfig.NEWS_BLACK.copy(), 1, 0);

        // 清除首页置顶新闻列表缓存
        this.clearRedisCacheOfTopNewsList(news.getAreaDetail(),null);
    }

    /**
     * @param newAreaCodeStr
     * @param oldAreaCodeStr
     * @Description 方法描述：清除首页置顶新闻列表缓存
     * @author leon 2019年1月15日 下午5:10:00
     * @CopyRight 杭州微财网络科技有限公司
     */
    private void clearRedisCacheOfTopNewsList(String newAreaCodeStr, String oldAreaCodeStr) {
        // 删除更新后的地区置顶新闻缓存
        if (StringUtils.isNotEmpty(newAreaCodeStr)) {
            String[] areaCodes = newAreaCodeStr.split(",");
            for (String areaCode : areaCodes) {
                KeyGenerator keyGenerator = RedisConfig.TOP_NEW_OF_AREA_LIST.copy().appendKey(areaCode);
                redisStringAdapter.remove(keyGenerator);
            }
        }
        // 删除更新前的地区置顶新闻缓存
        if (StringUtils.isNotEmpty(oldAreaCodeStr)) {
            String[] areaCodes = oldAreaCodeStr.split(",");
            for (String obj : areaCodes) {
                KeyGenerator keyGenerator = RedisConfig.TOP_NEW_OF_AREA_LIST.copy().appendKey(obj);
                redisStringAdapter.remove(keyGenerator);
            }
        }
        // 清除全国性置顶新闻缓存
        redisStringAdapter.remove(RedisConfig.TOP_NEW_OF_WHOLE_COUNTRY_LIST);
    }
}
