package com.bxm.localnews.admin.service.news.impl;

import com.bxm.localnews.admin.param.NewsBlackParam;
import com.bxm.localnews.admin.service.news.VideoService;
import com.bxm.localnews.admin.vo.GlobalVideoBlackEntity;
import com.bxm.localnews.admin.vo.Video;
import com.bxm.localnews.news.domain.AdminNewsMapper;
import com.bxm.localnews.news.domain.AdminVideoBlackMapper;
import com.bxm.localnews.news.domain.AdminVideoMapper;
import com.bxm.newidea.component.vo.PageWarper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Calendar;

@Service
public class VideoServiceImpl implements VideoService {

    private AdminVideoMapper adminVideoMapper;

    private AdminVideoBlackMapper adminVideoBlackMapper;


    @Autowired
    public VideoServiceImpl(AdminVideoMapper adminVideoMapper, AdminVideoBlackMapper adminVideoBlackMapper, AdminNewsMapper adminNewsMapper) {
        this.adminVideoMapper = adminVideoMapper;
        this.adminVideoBlackMapper = adminVideoBlackMapper;
    }

    @Override
    public PageWarper<Video> findVideoByTitleAndStatus(NewsBlackParam param) {
        return new PageWarper<>(adminVideoMapper.selectByTitleAndStatus(param));
    }

    @Transactional
    @Override
    public void addVideoBlack(Long id, String remark) {
        GlobalVideoBlackEntity entity = new GlobalVideoBlackEntity();
        entity.setCreateTime(Calendar.getInstance().getTime());
        entity.setRemark(remark);
        entity.setType(0);//无意义缺省值
        entity.setVideoId(id);
        adminVideoBlackMapper.insert(entity);
        adminVideoMapper.updateVideoStatus(id, 0);
    }


}
