package com.bxm.localnews.admin.service.recommend;

import com.bxm.localnews.admin.dto.MixRecommandDTO;
import com.bxm.localnews.admin.param.MixPoolParam;
import com.bxm.localnews.admin.param.MixRecommandParam;
import com.bxm.localnews.admin.param.MixRecommendTopParam;
import com.bxm.localnews.admin.vo.MixedRecommendPool;
import com.bxm.newidea.component.vo.PageWarper;

public interface MixRecommendPoolService {
    /**
     * 推荐池分页查询
     * @param mixRecommandParam
     * @return
     */
    PageWarper<MixRecommandDTO> getPagenationList(MixRecommandParam mixRecommandParam);

    /**
     * 取消推荐
     * @param mixPoolParam
     * @return
     */
    int cancelRecommendById(MixPoolParam mixPoolParam);

    /**
     * 修改推荐池权重
     * @param mixPoolParam
     * @param weight
     * @return
     */
    int updateMixRecommandWeight(MixPoolParam mixPoolParam, Integer weight);

    /**
     * 修改推荐池中的内容
     * @param mixedRecommendPool
     * @return
     */
    int updateMixRecommend(MixedRecommendPool mixedRecommendPool);

    /**
     * 推荐池置顶
     * @param mixPoolParam
     * @return
     */
    int addTop(MixRecommendTopParam mixPoolParam);
}
