package com.bxm.localnews.admin.service.recommend.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.admin.domain.AreaCodeMapper;
import com.bxm.localnews.admin.dto.MixRecommandDTO;
import com.bxm.localnews.admin.param.MixPoolParam;
import com.bxm.localnews.admin.param.MixRecommandParam;
import com.bxm.localnews.admin.param.MixRecommendTopParam;
import com.bxm.localnews.admin.service.recommend.MixRecommendPoolService;
import com.bxm.localnews.admin.vo.AreaCode;
import com.bxm.localnews.admin.vo.MixedRecommendPool;
import com.bxm.localnews.admin.vo.MixedRecommendPoolExample;
import com.bxm.localnews.admin.vo.News;
import com.bxm.localnews.news.domain.AdminNewsMapper;
import com.bxm.localnews.news.domain.MixedRecommendPoolMapper;
import com.bxm.newidea.component.vo.PageWarper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

@Service
@Slf4j
public class MixRecommendPoolServiceImpl implements MixRecommendPoolService {

    private MixedRecommendPoolMapper mixedRecommendPoolMapper;
    private AdminNewsMapper adminNewsMapper;
    private AreaCodeMapper areaCodeMapper;

    @Autowired
    public MixRecommendPoolServiceImpl(MixedRecommendPoolMapper mixedRecommendPoolMapper,
                                       AdminNewsMapper adminNewsMapper,
                                       AreaCodeMapper areaCodeMapper){
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
        this.adminNewsMapper = adminNewsMapper;
        this.areaCodeMapper = areaCodeMapper;
    }


    @Override
    public PageWarper<MixRecommandDTO> getPagenationList(MixRecommandParam mixRecommandParam) {
        PageWarper<MixRecommandDTO> pageWarper = new PageWarper<>(mixedRecommendPoolMapper.queryByPageSize(mixRecommandParam));
        List<MixRecommandDTO> list = pageWarper.getList();
        list.stream().forEach( e->{
            if (StringUtils.isNotBlank( e.getAreaDetail())) {
                List<AreaCode> areaCodeList = areaCodeMapper.findListByCode(e.getAreaDetail().split(","));
                e.setAreaDetail(JSONObject.toJSONString(areaCodeList));
            }
        });
        pageWarper.setList(list);
        return pageWarper;
    }

    @Override
    public int cancelRecommendById(MixPoolParam mixPoolParam) {
        MixedRecommendPoolExample example = new MixedRecommendPoolExample();
        example.createCriteria().andIdEqualTo(mixPoolParam.getId()).andOriginEqualTo(mixPoolParam.getOrigin());
        int result = mixedRecommendPoolMapper.deleteByExample(example);
        //将新闻状态改为未推荐
        if (StringUtils.equals("2",mixPoolParam.getOrigin()) || StringUtils.equals("3",mixPoolParam.getOrigin())){
            News news = new News();
            news.setId(mixPoolParam.getId());
            news.setIsRecommend((byte) 0);
            adminNewsMapper.updateByPrimaryKeySelective(news);
        }

        return result;
    }

    @Override
    public int updateMixRecommandWeight(MixPoolParam mixPoolParam, Integer weight) {
        MixedRecommendPoolExample example = new MixedRecommendPoolExample();
        example.createCriteria().andIdEqualTo(mixPoolParam.getId()).andOriginEqualTo(mixPoolParam.getOrigin());
        MixedRecommendPool pool = new MixedRecommendPool();
        pool.setWeight(weight);
        int result = mixedRecommendPoolMapper.updateByExampleSelective(pool, example);
        return result;
    }

    @Override
    public int updateMixRecommend(MixedRecommendPool mixedRecommendPool) {
        MixedRecommendPoolExample example = new MixedRecommendPoolExample();
        if (StringUtils.equals("1",mixedRecommendPool.getOrigin())){
            example.createCriteria().andOriginEqualTo(mixedRecommendPool.getOrigin()).andIdEqualTo(mixedRecommendPool.getId());
        }else{
            //当传过的参数类型不是帖子时更新新闻
            example.createCriteria().andOriginNotEqualTo("1").andIdEqualTo(mixedRecommendPool.getId());
        }
        int result = mixedRecommendPoolMapper.updateByExampleSelective(mixedRecommendPool, example);
        return result;
    }

    @Override
    public int addTop(MixRecommendTopParam mixPoolParam) {
        int result = 0;
        if (StringUtils.isNotBlank(mixPoolParam.getNewsId())){
            String[] newsIds = mixPoolParam.getNewsId().split(",");
            for (String e: newsIds) {
                Long newsId = NumberUtils.toLong(e);
                MixedRecommendPool mixedRecommendPool = new MixedRecommendPool();
                mixedRecommendPool.setId(newsId);
                //将新闻设置成置顶
                mixedRecommendPool.setTop((byte)2);
                mixedRecommendPool.setTopEffectiveTime(mixPoolParam.getNewsEffectiveTime());
                mixedRecommendPool.setTopExpireTime(mixPoolParam.getNewsExpireTime());
                result += mixedRecommendPoolMapper.updateByPrimaryKeySelective(mixedRecommendPool);
            }
        }
        if (StringUtils.isNotBlank(mixPoolParam.getPostId())){
            String[] postIds = mixPoolParam.getPostId().split(",");
            for (String e: postIds) {
                Long postId = NumberUtils.toLong(e);
                MixedRecommendPool mixedRecommendPool = new MixedRecommendPool();
                mixedRecommendPool.setId(postId);
                //将帖子设置成置顶
                mixedRecommendPool.setTop((byte)2);
                mixedRecommendPool.setTopEffectiveTime(mixPoolParam.getPostEffectiveTime());
                mixedRecommendPool.setTopExpireTime(mixPoolParam.getPostExpireTime());
                result += mixedRecommendPoolMapper.updateByPrimaryKeySelective(mixedRecommendPool);
            }
        }

        return result;
    }
}
