package com.bxm.localnews.admin.service.security.impl;

import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.dto.UserInfoDTO;
import com.bxm.localnews.admin.param.UserInfoParam;
import com.bxm.localnews.admin.service.security.AdminUserBaseInfoService;
import com.bxm.localnews.admin.vo.User;
import com.bxm.newidea.component.vo.PageWarper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/12/19.
 */

@Service
public class AdminUserBaseInfoServiceImpl implements AdminUserBaseInfoService {

    @Resource
    private UserMapper userBaseInfoMapper;

    @Override
    public PageWarper<UserInfoDTO> queryUserInfoDTO(UserInfoParam param) {
        return new PageWarper<>(this.userBaseInfoMapper.queryUserByPageSize(param));
    }

    @Override
    public User selectByUserId(Long userId) {
        return this.userBaseInfoMapper.selectByUserId(userId);
    }

    @Override
    public boolean updateUserBlack(Map<String, Object> map) {
        return this.userBaseInfoMapper.updateUserBlack(map);
    }

    @Override
    public List<UserInfoDTO> getVirtualUserList() {
        UserInfoParam param = new UserInfoParam();
        param.setState(3);
        param.setPageSize(200);
        return this.userBaseInfoMapper.queryUserByPageSize(param);
    }
    
}
