package com.bxm.localnews.admin.sync.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix = "sync")
@Component
@Data
public class SyncProperties {

    /**
     * 新闻标签采样数量
     */
    private int tagPickCount;

    /**
     * 临时文件存储目录
     */
    private String tempDir;

    /**
     * 获取抖音视频列表Api
     */
    private String douyinApi;

    /**
     * 获取秒拍视频列表Api
     */
    private String miaopaiApi;

    /**
     * 获取美拍视频列表Api
     */
    private String meipaiApi;

    /**
     * ApiKey
     */
    private String videoApiKey;

    /**
     * 同步小视频的开关
     */
    private Byte swtichType;
}
