package com.bxm.localnews.admin.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 通用的业务配置，具体模块的配置需要在对应的模块内创建properties和特定的前缀接收
 * @author liujia 2018/7/26 16:45
 */
@Component
@Data
@ConfigurationProperties("common.config")
public class BizConfigProperties {

    /**
     * 临时文件存储目录
     */
    private String tempDir;

    /**
     * 后端API域名
     */
    private String serverHost;

    /**
     * h5访问根路径
     */
    private String h5ServerHost;

    /**
     * 应用图标地址
     */
    private String appIconUrl;

    /**
     * 推广渠道链接H5地址
     */
    private String channelUrl;

    /**
     * APP下载H5地址
     */
    private String downloadUrl;

    /**
     * 活动分享链接
     */
    private String privilegeShareUrl;
}
