package com.bxm.localnews.admin.constant;

/**
 * 活动状态枚举
 */
public enum PrivilegeStatusEnum {
    /**
     * 未开始
     */
    WAIT(2),
    /**
     * 进行中
     */
    BEGIN(3),
    /**
     * 已结束
     */
    FINISH(1),
    /**
     * 已取消
     */
    CANCEL(0);

    private int code;

    PrivilegeStatusEnum(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }
}
