package com.bxm.localnews.admin.service.activity;

import com.bxm.localnews.admin.param.PointMallParam;
import com.bxm.localnews.admin.vo.PointMall;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * @author zhaoyadong 2019/2/15 14:39
 * @desc
 */
public interface PointMallService {

    /**
     * 查询积分商城列表
     * @param param 积分商城参数
     * @return 分页结果
     */
    PageWarper<PointMall> queryPointMalls(PointMallParam param);

    /**
     * 获取积分商城详情
     * @param id
     * @return
     */
    PointMall selectByPrimaryKey(Long id);

    /**
     * 积分商城上下架
     * @param id
     * @param status
     * @return 更新信息
     */
    int updatePointMallStatus(Long id, Byte status);

    /**
     * 新增或编辑积分商城
     * @param pointMall
     * @return
     */
    int addPointMall(PointMall pointMall);

    /**
     * 删除商品
     * @param id
     * @return
     */
    int remove(Long id);
}
