package com.bxm.localnews.admin.service.activity;

import com.bxm.localnews.admin.dto.RedPacketDTO;
import com.bxm.localnews.admin.param.RedPacketParam;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 红包相关服务
 * @author donghy
 */
public interface RedPacketService {

    /**
     * 分页获取红包列表
     * @param redPacketParam 请求参数
     * @return 分页结果
     */
    PageWarper<RedPacketDTO> queryList(RedPacketParam redPacketParam);


    /**
     * 审核结果
     * @param id 红包id
     * @param approvalStatus 审核状态,0：拒绝,1：通过
     * @param approvalContent 如果审核状态为0:拒绝,需要填写审核内容（拒绝原因）
     * @return 审核结果
     */
    boolean approvalRedPacket(Long id, Integer approvalStatus, String approvalContent);

    /**
     * 更新上下线状态
     * @param id 红包id
     * @param onlineStatus
     * @return
     */
    boolean updateOnlineStatus(Long id, Integer onlineStatus);

    /**
     * 获取红包详情
     * @param id 红包id
     * @return 红包详情
     */
    RedPacketDTO getRedPacketDetail(Long id);

    /**
     * 编辑红包
     * @param redPacketParam 请求参数
     * @return 编辑结果
     */
    boolean editRedPacket(RedPacketParam redPacketParam);

}
