package com.bxm.localnews.admin.service.activity.impl;

import com.bxm.localnews.admin.constant.ApproveResultEnum;
import com.bxm.localnews.admin.constant.ApproveTypeEnum;
import com.bxm.localnews.admin.constant.SourceTypeEnum;
import com.bxm.localnews.admin.domain.MerchantMapper;
import com.bxm.localnews.admin.dto.AreaDivisionDetailDTO;
import com.bxm.localnews.admin.param.MerchantParam;
import com.bxm.localnews.admin.param.MerchantQueryParam;
import com.bxm.localnews.admin.service.PushMsgIntegService;
import com.bxm.localnews.admin.service.activity.MerchantService;
import com.bxm.localnews.admin.service.base.ApproveHistoryService;
import com.bxm.localnews.admin.service.base.AreaDivisionService;
import com.bxm.localnews.admin.service.security.BaseAdminService;
import com.bxm.localnews.admin.vo.BaseMerchantBean;
import com.bxm.localnews.admin.vo.MerchantBean;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.newidea.component.geo.dto.Coordinate;
import com.bxm.newidea.component.geo.service.GeoService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class MerchantServiceImpl extends BaseAdminService implements MerchantService {

    private MerchantMapper merchantMapper;

    private GeoService geoService;

    private AreaDivisionService areaDivisionService;

    private ApproveHistoryService approveHistoryService;

    private PushMsgIntegService pushMsgIntegService;

    @Autowired
    public MerchantServiceImpl(MerchantMapper merchantMapper, GeoService geoService,
                               AreaDivisionService areaDivisionService, ApproveHistoryService approveHistoryService,
                               PushMsgIntegService pushMsgIntegService) {
        this.merchantMapper = merchantMapper;
        this.geoService = geoService;
        this.areaDivisionService = areaDivisionService;
        this.approveHistoryService = approveHistoryService;
        this.pushMsgIntegService = pushMsgIntegService;
    }

    @Override
    public PageWarper<MerchantBean> getMerchants(MerchantQueryParam param) {
        Preconditions.checkArgument(param != null);

        List<MerchantBean> result = merchantMapper.queryByPageSize(param);

        for (MerchantBean entity : result) {
            String lastLevelFullName = areaDivisionService.getAreaDivisionDTO(getLastLevelCode(entity)).getFullName();
            if (StringUtils.isNotBlank(lastLevelFullName)) {
                if (StringUtils.isNotBlank(entity.getDetailAddress())) {
                    lastLevelFullName += entity.getDetailAddress();
                }
                entity.setLastLevelAddress(lastLevelFullName);
            }
        }

        return new PageWarper<>(result);
    }

    @Override
    public MerchantBean getMerchant(long id) {
        return merchantMapper.get(id);
    }

    @Override
    public Message save(MerchantParam param) {
        MerchantBean entity = convert(param);
        entity.setSourceType(SourceTypeEnum.ADD.name());
        entity.setAddTime(new Date());
//        //默认审核通过
//        entity.setStatus(ApproveResultEnum.OK.getCode());
        //康文静说的默认审核不通过2018-11-12 15:09  modify by Arei
        entity.setStatus(ApproveResultEnum.INIT.getCode());
        return Message.build(merchantMapper.insert(entity));
    }

    @Override
    public Message modify(MerchantParam param) {
        MerchantBean entity = convert(param);
        entity.setId(param.getId());
        return Message.build(merchantMapper.update(entity));
    }

    private MerchantBean convert(MerchantParam param) {
        MerchantBean entity = new MerchantBean();
        entity.setAddTime(new Date());

        BeanUtils.copyProperties(param, entity);

        //根据地区编码获取地区简称，组装商户显示地址
        AreaDivisionDetailDTO countyInfo = areaDivisionService.getAreaDivisionDTO(param.getCountyCode());
        if (null != countyInfo) {
            entity.setDisplayAddress(countyInfo.getName() + param.getDetailAddress());
        }

        //根据街区编码获取街区名称,用于活动列表中直接显示
        entity.setTownName(areaDivisionService.getAreaDivisionDTO(param.getTownCode()).getName());

        //设置商户位置的经纬度地址
        Coordinate location = getLocation(param);
        if (null != location) {
            entity.setLat(location.getLatitude());
            entity.setLng(location.getLongitude());
        }

        return entity;
    }

    private String getLastLevelCode(BaseMerchantBean merchant) {
        String lastLevelCode = merchant.getTownCode();
        if (StringUtils.isBlank(lastLevelCode)) {
            lastLevelCode = merchant.getCountyCode();
        }
        if (StringUtils.isBlank(lastLevelCode)) {
            lastLevelCode = merchant.getCityCode();
        }
        if (StringUtils.isBlank(lastLevelCode)) {
            lastLevelCode = merchant.getProvinceCode();
        }
        return lastLevelCode;
    }

    private Coordinate getLocation(MerchantParam param) {
        if (null != param.getLat() && null != param.getLng()) {
            Coordinate coordinate = new Coordinate();
            coordinate.setLatitude(param.getLat());
            coordinate.setLongitude(param.getLng());
            return coordinate;
        }
        AreaDivisionDetailDTO lastLevel = areaDivisionService.getAreaDivisionDTO(getLastLevelCode(param));
        if (null != lastLevel) {
            //组装商户地址，获取商户的详细经纬度地址
            String locationDetail = lastLevel.getFullName() + param.getDetailAddress();
            return geoService.getCoordinate(locationDetail);

        }
        return null;
    }

    @Override
    public List<MerchantBean> getTopMatch(String merchantName) {
        return merchantMapper.queryTopMatch(merchantName);
    }

    @Override
    public Message changeStatus(long id, int status, String rejectReason) {
        MerchantBean merchant = getMerchant(id);
        Message message = Message.build();

        if (null != merchant) {
            message.append(Message.build(merchantMapper.change(id, status)));
            if (status != 0) {
                message.append(approveHistoryService.save(ApproveTypeEnum.MERCHANT, ApproveResultEnum.get(status), id, rejectReason));
            }

            //如果商户信息是用户提交，则给对应的用户发送push
            if (status != 0 && merchant.getUserId() > 0) {
                PushMessage pushMessage = null;

//                if (status == ApproveResultEnum.OK.getCode()) {
//                    pushMessage = PushMessage.build("商家信息审核通过", "您的信息已审核通过，稍后将有工作人员联系您，请保持电话畅通！", merchant.getUserId());
//                    PushPayloadInfo payloadInfo = PushPayloadInfo.build(PushMessageEnum.ORDINARY_MSG);
//                    pushMessage.setPayloadInfo(payloadInfo);
//                } else if (status == ApproveResultEnum.REJECT.getCode()) {
//                    String reason = org.springframework.util.StringUtils.isEmpty(rejectReason) ?
//                            "" : ",原因是[" + rejectReason + "],可重新提交审核！";
//                    pushMessage = PushMessage.build("商家信息审核未通过", "您的商家信息未通过" + reason, merchant.getUserId());
//                    PushPayloadInfo payloadInfo = PushPayloadInfo.build(PushMessageEnum.MERCHANT_VERIFY);
//                    pushMessage.setPayloadInfo(payloadInfo);
//
//                }
                if (null != pushMessage) {

                    pushMsgIntegService.pushMsg(pushMessage);
                }
            }
        }

        return message;
    }

    @Override
    public Message remove(long id) {
        return Message.build(merchantMapper.remove(id));
    }

}
