package com.bxm.localnews.admin.service.activity.impl;

import java.util.Date;
import java.util.List;

import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.admin.config.BizConfigProperties;
import com.bxm.localnews.admin.constant.PrivilegeStatusEnum;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.PrivilegeAreaMapper;
import com.bxm.localnews.admin.domain.PrivilegeMapper;
import com.bxm.localnews.admin.dto.PrivilegeListDTO;
import com.bxm.localnews.admin.param.PrivilegeParam;
import com.bxm.localnews.admin.param.PrivilegeQueryParam;
import com.bxm.localnews.admin.service.activity.CommodityService;
import com.bxm.localnews.admin.service.activity.PrivilegeService;
import com.bxm.localnews.admin.service.base.ShortLinkService;
import com.bxm.localnews.admin.vo.CommodityBean;
import com.bxm.localnews.admin.vo.PrivilegeAreaBean;
import com.bxm.localnews.admin.vo.PrivilegeBean;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;

import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrivilegeServiceImpl extends BaseService implements PrivilegeService {

    private PrivilegeMapper privilegeMapper;

    private AliyunOSSService aliyunOSSService;

    private CommodityService commodityService;

    private HttpClientService httpClientService;

    private PrivilegeAreaMapper privilegeAreaMapper;

    private ShortLinkService shortLinkService;

    private BizConfigProperties bizConfigProperties;


    private RedisStringAdapter redisStringAdapter;

    private SqlSessionTemplate primarySessionTemplate;

    @Autowired
    public PrivilegeServiceImpl(PrivilegeMapper privilegeMapper, PrivilegeAreaMapper privilegeAreaMapper,
                                AliyunOSSService aliyunOSSService,
                                CommodityService commodityService, HttpClientService httpClientService,
                                ShortLinkService shortLinkService, BizConfigProperties bizConfigProperties,
                                RedisStringAdapter redisStringAdapter, SqlSessionTemplate primarySessionTemplate) {
        this.privilegeMapper = privilegeMapper;
        this.aliyunOSSService = aliyunOSSService;
        this.commodityService = commodityService;
        this.httpClientService = httpClientService;
        this.privilegeAreaMapper = privilegeAreaMapper;
        this.shortLinkService = shortLinkService;
        this.bizConfigProperties = bizConfigProperties;
        this.redisStringAdapter = redisStringAdapter;
        this.primarySessionTemplate = primarySessionTemplate;
    }

    @Override
    public Message save(PrivilegeParam param) {
        PrivilegeBean entity = convert(param);
        entity.setShareBgUrl(param.getThumbnailUrl());
        entity.setDeleteFlag(0);
        entity.setAddTime(new Date());
        //活动默认进行中状态，于181212改
        entity.setStatus(PrivilegeStatusEnum.BEGIN.getCode());

        saveAreaRelation(param, entity.getId());
        privilegeMapper.insert(entity);

        this.updateRedisByPrivilegeArea(param.getAreaCodes());

        return Message.build(1);
    }

    private KeyGenerator getPriviligeListKey(String areaCode) {
        return RedisConfig.PRIVILEGE_lIST.copy().appendKey(areaCode);
    }

    /**
     * 保存活动的投放区域信息
     *
     * @param param 新增、编辑参数
     * @param id    活动ID
     */
    private void saveAreaRelation(PrivilegeParam param, long id) {
        //移除投放区域
        privilegeAreaMapper.deleteByPrivilegeId(id);
        if (param.getGlobalFlag() == 1) {
            return;
        }
        if (StringUtils.isNotBlank(param.getAreaCodes())) {
            String[] relationCodeArray = StringUtils.split(param.getAreaCodes(), ",");

            MybatisBatchBuilder.create(PrivilegeAreaMapper.class, relationCodeArray)
                    .sessionTemplate(primarySessionTemplate)
                    .run((mapper, element) -> {
                        PrivilegeAreaBean privilegeAreaBean = new PrivilegeAreaBean();
                        privilegeAreaBean.setId(nextId());
                        privilegeAreaBean.setAreaCode(element);
                        privilegeAreaBean.setPrivilegeId(id);
                        return mapper.insert(privilegeAreaBean);
                    });
        }
    }

    @Override
    public Message modify(PrivilegeParam param) {
        Message message = Message.build(1);

        PrivilegeBean entity = convert(param);
        //保存投放区域
        saveAreaRelation(param, entity.getId());
        privilegeMapper.updateByPrimaryKey(entity);
        this.updateRedisByPrivilegeArea(param.getAreaCodes());
        return message;
    }

    private PrivilegeBean convert(PrivilegeParam param) {
        PrivilegeBean entity = new PrivilegeBean();
        BeanUtils.copyProperties(param, entity);

        if (param.getId() <= 0) {
            entity.setId(nextId());
        }

        //根据商品ID获取商户ID
        if (param.getCommodityId() > 0) {
            CommodityBean commodityDetail = commodityService.get(param.getCommodityId());
            if (null != commodityDetail) {
                entity.setMerchantId(commodityDetail.getMechantId());
            } else {
                logger.error("商品[{}]已被删除，关联活动的商品不允许删除", param.getCommodityId());
            }
        }

        return entity;
    }

    @Override
    public PageWarper<PrivilegeBean> queryByPage(PrivilegeQueryParam param) {
        Preconditions.checkArgument(param != null);
        PageWarper<PrivilegeBean> pageWarper = new PageWarper<PrivilegeBean>(privilegeMapper.queryByPageSize(param));
        pageWarper.getList().forEach(privilegeBean -> {
            privilegeBean.setPrivilegeAreas(privilegeAreaMapper.getPrivilegeAreas(privilegeBean.getId()));
        });
        pageWarper.getList().forEach(privilegeBean -> {
            privilegeBean.setShortUrl4QRCode(
                    shortLinkService.getPrivilegeShareShortLink("id=" + privilegeBean.getId() + "&posterFlag=chook"));
        });
        pageWarper.getList().forEach(privilegeBean -> {
            privilegeBean.setShortUrl4Poster(
                    shortLinkService.getPrivilegeShareShortLink("id=" + privilegeBean.getId()));
        });
        return pageWarper;
    }

    @Override
    public PrivilegeBean get(long id) {
        PrivilegeBean entity = privilegeMapper.selectByPrimaryKey(id);

        entity.setPrivilegeAreas(privilegeAreaMapper.getPrivilegeAreas(entity.getId()));
        return entity;
    }

    @Override
    public Message remove(long id) {
        PrivilegeBean entity = get(id);
        if (entity == null) {
            return Message.build(false).setMessage("活动ID不正确，无法删除");
        }

        //删除定时任务
        Message message = Message.build(privilegeMapper.deleteByPrimaryKey(id));
        this.updateRedisByPrivilegeId(id);
        return message;
    }

    @Override
    public Message changeEnable(long id, int status) {
        privilegeMapper.changeEnable(id, status);
        if (status == 1) {
            PrivilegeBean entity = get(id);
        }
        this.updateRedisByPrivilegeId(id);
        return Message.build(true);
    }

    @Override
    public Message changeOrder(long id, int order) {
        privilegeMapper.changeOrder(id, order);
        this.updateRedisByPrivilegeId(id);
        return Message.build(true);
    }

    private void updateRedisByPrivilegeId(long id) {
        List<PrivilegeAreaBean> privilegeAreaBeanList = privilegeAreaMapper.getPrivilegeAreas(id);
        for (PrivilegeAreaBean privilegeAreaBean : privilegeAreaBeanList) {
            List<PrivilegeListDTO> privilegeListDTOList = privilegeMapper.listAllPrivilege(privilegeAreaBean.getAreaCode());
            this.redisStringAdapter.set(this.getPriviligeListKey(privilegeAreaBean.getAreaCode()), privilegeListDTOList);
        }
    }

    private void updateRedisByPrivilegeArea(String codes) {
        //todo 当新增全国活动时要在每个开通的城市更新缓存
        if (StringUtils.isEmpty(codes)) {
            return;
        }
        String[] relationCodeArray = StringUtils.split(codes, ",");
        for (String code : relationCodeArray) {
            List<PrivilegeListDTO> privilegeListDTOList = privilegeMapper.listAllPrivilege(code);
            this.redisStringAdapter.set(this.getPriviligeListKey(code), privilegeListDTOList);
        }
    }

}
