package com.bxm.localnews.admin.service.base;

import com.bxm.localnews.admin.dto.ToolsDTO;
import com.bxm.localnews.admin.dto.TooltipStrategyDTO;
import com.bxm.localnews.admin.param.ToolsInfoParam;
import com.bxm.localnews.admin.param.ToolsParam;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * @author zhaoyadong 2018/10/23 13:51
 * @desc
 */
public interface AdminToolsService {
    /**
     * 查询工具
     * @param toolsParam 工具参数
     * @return 分页结果
     */
    PageWarper<ToolsDTO> getToolsList(ToolsParam toolsParam);

    /**
     * 工具详情
     * @param id
     * @return
     */
    ToolsDTO getToolsById(Long id);

    /**
     * 批量更新工具状态
     * @param ids
     * @param status
     * @return 更新的行数
     */
    int updateToolsStatusById(String[] ids, Byte status);

    /**
     * 更新工具状态
     * @param id
     * @param status
     * @return 更新的行数
     */
    int updateToolsStatusById(Long id, Byte status);

    /**
     * 新增或编辑广告
     * @param toolsInfoParam 工具信息参数
     * @return
     */
    int addToolsDetail(ToolsInfoParam toolsInfoParam);

    /**
     * 删除广告
     * @param id
     * @return
     */
    int deleteTools(Long id);

    /**
     * 获取所有工具提示语策略信息
     * @return 查询结果
     */
    List<TooltipStrategyDTO> getAllTooltipStrategy();
}
