package com.bxm.localnews.admin.service.base;


import com.bxm.localnews.admin.dto.LocationDTO;
import com.bxm.localnews.admin.param.LocationParam;

import java.util.List;

/**
 * 地区相关接口
 */
public interface LocationService {

    /**
     * 用途：显示所有平铺城市
     * @param locationParam
     * @return
     */
    List<LocationDTO> listLocation(LocationParam locationParam);

    /**
     * 用途：根据编号新增热门城市
     * @param code
     */
    void saveHotLocation(String code);

    /**
     * 用途：根据编号新增已开通城市
     * @param code
     */
    void saveOpenedLocation(String code);

    /**
     * 用途：根据城市编号查询该城市下的已开通城市  省->市->市或县
     * @param code
     * @return
     */
    List<LocationDTO> listOpenedLocationByArea(String code, Byte show);

    /**
     * 用途：根据城市编号查询该城市下的已开通城市 省->市或县
     * @param code
     * @return
     */
    List<LocationDTO> listOpenedLocationByAreaWithTwoLevels(String code, Byte show);


}
