package com.bxm.localnews.admin.service.base;

import java.util.List;

import com.bxm.localnews.admin.dto.VirtualUserOverviewDTO;
import com.bxm.localnews.admin.param.VirtualUserInfoParam;
import com.bxm.localnews.admin.param.VirtualUserParam;
import com.bxm.localnews.admin.param.VirtualUserQueryParam;
import com.bxm.localnews.admin.vo.VirtualUser;
import com.bxm.newidea.component.vo.PageWarper;

public interface VirtualUserService {

    /**
     * 用途：保存马甲号信息，如果id有值，则更新该id下的马甲号信息
     *
     * @param virtualUser
     */
    void save(VirtualUserInfoParam virtualUser);

    /**
     * 用途：分页获取马甲号的信息
     *
     * @param virtualUserParam
     */
    PageWarper<VirtualUser> listByPage(VirtualUserParam virtualUserParam);

    /**
     * 用途：按某种策略获取马甲号的信息
     *
     * @param virtualUserQueryParam
     */
    List<VirtualUserOverviewDTO> list(VirtualUserQueryParam virtualUserQueryParam);

    /**
     * 根据id获取马甲号详情
     *
     * @param id
     * @return
     */
    VirtualUser getVirtualUserDetail(Long id);

}
