package com.bxm.localnews.admin.service.base.impl;

import java.util.List;
import java.util.stream.Collectors;

import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.convert.impl.VirtualUserConverter;
import com.bxm.localnews.admin.convert.impl.VirtualUserInfoConverter;
import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.domain.VirtualUserMapper;
import com.bxm.localnews.admin.dto.VirtualUserOverviewDTO;
import com.bxm.localnews.admin.integration.NewsIntegrationService;
import com.bxm.localnews.admin.param.VirtualUserInfoParam;
import com.bxm.localnews.admin.param.VirtualUserParam;
import com.bxm.localnews.admin.param.VirtualUserQueryParam;
import com.bxm.localnews.admin.service.base.VirtualUserService;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.admin.vo.VirtualUser;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VirtualUserServiceImpl implements VirtualUserService {

    @Autowired
    private UserMapper userMapper;

    @Autowired
    private VirtualUserMapper virtualUserMapper;

    @Autowired
    private VirtualUserConverter virtualUserConverter;

    @Autowired
    private VirtualUserInfoConverter virtualUserInfoConverter;

    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    private NewsIntegrationService newsIntegrationService;

    @Override
    public void save(VirtualUserInfoParam virtualUser) {
        User user = virtualUserConverter.convert(virtualUser);
        VirtualUser virtualUserVo = virtualUserInfoConverter.convert(virtualUser);

        if (null == virtualUser.getId()) {
            //新增
            userMapper.insertSelective(user);

            virtualUserVo.setId(user.getId());
            virtualUserMapper.insertSelective(virtualUserVo);
        } else {
            //更新
            userMapper.updateByPrimaryKeySelective(user);
            virtualUserMapper.updateByPrimaryKeySelective(virtualUser);
            //删除缓存
            redisHashMapAdapter.remove(RedisConfig.USER_INFO, String.valueOf(virtualUser.getId()));
            //更新用户冗余信息
            newsIntegrationService.syncUser();

        }
    }

    @Override
    public PageWarper<VirtualUser> listByPage(VirtualUserParam virtualUserParam) {
        return new PageWarper<>(virtualUserMapper.queryPageSize(virtualUserParam));
    }

    @Override
    public List<VirtualUserOverviewDTO> list(VirtualUserQueryParam virtualUserQueryParam) {
        VirtualUser virtualUser = new VirtualUser();
        BeanUtils.copyProperties(virtualUserQueryParam, virtualUser);
        List<VirtualUser> virtualUserList = virtualUserMapper.selectByModel(virtualUser);
        List<VirtualUserOverviewDTO> virtualUserOverviewDTOList = virtualUserList.stream().map(e -> {
            VirtualUserOverviewDTO virtualUserOverviewDTO = new VirtualUserOverviewDTO();
            virtualUserOverviewDTO.setHeadImg(e.getHeadImg());
            virtualUserOverviewDTO.setId(e.getId());
            virtualUserOverviewDTO.setNickname(e.getNickname());
            //方仙女(女  单身，广德)
            virtualUserOverviewDTO.setUserInfo(getUserInfo(e.getNickname() + "(" + getSex(e.getSex()), e.getRemark()));
            return virtualUserOverviewDTO;
        }).collect(Collectors.toList());
        return virtualUserOverviewDTOList;
    }

    @Override
    public VirtualUser getVirtualUserDetail(Long id) {
        VirtualUser virtualUserParam = new VirtualUser();
        virtualUserParam.setId(id);
        List<VirtualUser> virtualUser = virtualUserMapper.selectByModel(virtualUserParam);
        if (CollectionUtils.isNotEmpty(virtualUser)) {
            return virtualUser.get(0);
        }
        return null;
    }

    private String getSex(Byte sex) {
        String sexStr = "男";
        if (null != sex && 1 == sex) {
            sexStr = "男";
        } else if (null != sex && 2 == sex) {
            sexStr = "女";
        }
        return sexStr;
    }

    private String getUserInfo(String userInfo, String remark) {
        if (StringUtils.isEmpty(remark)) {
            return userInfo + ")";
        } else {
            return userInfo + " " + remark + ")";
        }
    }
}
