package com.bxm.localnews.admin.service.editor.impl;

import com.bxm.localnews.admin.convert.impl.EditorMessageConverter;
import com.bxm.localnews.admin.param.EditorMessageParam;
import com.bxm.localnews.admin.service.editor.EditorMessageService;
import com.bxm.localnews.admin.vo.BasicEditorMessage;
import com.bxm.localnews.admin.vo.EditorMessage;
import com.bxm.localnews.news.domain.AdminNewsMapper;
import com.bxm.localnews.news.domain.EditorMessageMapper;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.PageParam;
import com.bxm.newidea.component.vo.PageWarper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@Service
public class EditorMessageServiceImpl extends BaseService implements EditorMessageService {

	private final EditorMessageConverter editorMessageConverter;

	private final EditorMessageMapper editorMessageMapper ;

	private final AdminNewsMapper newsMapper;

	private final ForumPostMapper forumPostMapper;

	@Autowired
	public EditorMessageServiceImpl(EditorMessageConverter editorMessageConverter,
									EditorMessageMapper editorMessageMapper,
									AdminNewsMapper newsMapper,
									ForumPostMapper forumPostMapper) {
		this.editorMessageConverter = editorMessageConverter;
		this.editorMessageMapper = editorMessageMapper;
		this.newsMapper = newsMapper;
		this.forumPostMapper = forumPostMapper;
	}

	@Override
	public int doSaveOrUpdateEditorMessage(EditorMessageParam param) {
		if (Objects.isNull(param.getId()) || param.getId() == 0 ){
			//新增编辑寄语
			EditorMessage editorMessage = editorMessageConverter.convert(param);
			return editorMessageMapper.insertSelective(editorMessage);
		}else{
			//修改编辑寄语
			EditorMessage editorMessage = new EditorMessage();
			BeanUtils.copyProperties(param,editorMessage);
			editorMessage.setModifyTime(new Date());
			int result = editorMessageMapper.updateByPrimaryKeySelective(editorMessage);
			int newsNum = newsMapper.updateEditMessageById(param);
			int postNum = forumPostMapper.updateEditMessageById(param);
			logger.info("更新帖子表寄语数量[{}],更新新闻表寄语数量[{}]",postNum,newsNum);
			return result;
		}
	}

	@Override
	public EditorMessage getEditorMessage(Long id) {
		return editorMessageMapper.selectByPrimaryKey(id);
	}

	@Override
	public List<BasicEditorMessage> listAll() {
		List<BasicEditorMessage> list = editorMessageMapper.getList(null);
		return list;
	}

	@Override
	public PageWarper<BasicEditorMessage>  listPage(PageParam pageParam) {
		PageWarper<BasicEditorMessage> forumList = new PageWarper<BasicEditorMessage>(editorMessageMapper.getList(pageParam));
		return forumList;
	}

	@Override
	public int deleteById(Long id) {
		int i = editorMessageMapper.deleteByPrimaryKey(id);
		int newsNum = newsMapper.deleteEditMessageById(id);
		int postNum = forumPostMapper.deleteEditMessageById(id);
		logger.info("更新帖子表寄语数量[{}],更新新闻表寄语数量[{}]",postNum,newsNum);
		return i;
	}
}
