package com.bxm.localnews.admin.service.forum;

import com.bxm.localnews.admin.param.ReplyLibraryParam;
import com.bxm.localnews.admin.param.ReplyOriginalParam;
import com.bxm.localnews.admin.vo.ReplyLibrary;
import com.bxm.localnews.admin.vo.ReplyLibraryCategory;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * 评论库管理服务
 */
public interface ReplyLibraryService {

    /**
     * 分页查询评论
     *
     * @param param 参数
     * @return 分页结果
     */
    PageWarper<ReplyLibrary> getList(ReplyLibraryParam param);

    /**
     * 获取评论详情
     *
     * @param id
     * @return
     */
    ReplyLibrary selectByPrimaryKey(Long id);

    /**
     * 批量新增评论
     *
     * @param replyLibraryList
     * @return
     */
    int batchInsert(List<ReplyLibrary> replyLibraryList);

    /**
     * 编辑评论
     *
     * @param replyLibrary
     * @return
     */
    int updateByPrimaryKey(ReplyLibrary replyLibrary);

    /**
     * 删除评论
     *
     * @param id
     * @return
     */
    int deleteByPrimaryKey(Long id);

    /**
     * 模拟评论生成
     *
     * @param param
     * @return
     */
    void generateVirtualReply(ReplyOriginalParam param);
}
