package com.bxm.localnews.admin.service.forum.impl;

import java.util.*;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.admin.config.BizConfigProperties;
import com.bxm.localnews.admin.constant.NewsStatusEnum;
import com.bxm.localnews.admin.domain.AreaCodeMapper;
import com.bxm.localnews.admin.domain.UserAccountMapper;
import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.domain.VirtualUserMapper;
import com.bxm.localnews.admin.dto.NewsCompleTaskDTO;
import com.bxm.localnews.admin.dto.PostTopicDTO;
import com.bxm.localnews.admin.dto.VirtualUserOverviewDTO;
import com.bxm.localnews.admin.integration.MissionIntegrationService;
import com.bxm.localnews.admin.integration.NewsRecommendIntegrationService;
import com.bxm.localnews.admin.integration.UserAccountIntegrationService;
import com.bxm.localnews.admin.param.*;
import com.bxm.localnews.admin.seq.NewsSeqComponent;
import com.bxm.localnews.admin.service.NewsSyncService;
import com.bxm.localnews.admin.service.PushMsgIntegService;
import com.bxm.localnews.admin.service.QuartzIntegrationService;
import com.bxm.localnews.admin.service.base.VirtualUserService;
import com.bxm.localnews.admin.service.forum.ForumPostService;
import com.bxm.localnews.admin.service.news.AdminNewsService;
import com.bxm.localnews.admin.service.news.CommonTagService;
import com.bxm.localnews.admin.service.recommend.MixRecommendPoolService;
import com.bxm.localnews.admin.sync.enums.NewsTagTypeEnum;
import com.bxm.localnews.admin.vo.*;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.news.domain.*;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class ForumPostServiceImpl extends BaseService implements ForumPostService {
    @Resource
    private UserMapper userMapper;

    @Resource
    private UserAccountMapper userAccountMapper;

    @Resource
    private ForumMapper forumMapper;

    @Resource
    private TopicMapper topicMapper;

    @Resource
    private ForumPostMapper forumPostMapper;

    @Resource
    private EditorMessageMapper editorMessageMapper;

    @Resource
    private SequenceCreater sequenceCreater;

    @Resource
    private AdminNewsService adminNewsService;

    @Resource
    private NewsSyncService newsSyncService;

    @Resource
    private CommonTagService commonTagService;

    @Resource
    private MixRecommendPoolService mixRecommendPoolService;

    @Resource
    private MissionIntegrationService missionIntegrationService;

    @Resource
    private UserAccountIntegrationService userAccountIntegrationService;

    @Resource
    private NewsSeqComponent newsSeqComponent;

    @Resource
    private PushMsgIntegService pushMsgIntegService;

    @Resource
    private BizConfigProperties bizConfigProperties;

    @Resource
    private MixedRecommendPoolMapper mixedRecommendPoolMapper;

    @Resource
    private NewsRecommendIntegrationService newsRecommendIntegrationService;

    @Resource
    private QuartzIntegrationService quartzIntegrationService;

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Resource
    private VirtualUserMapper virtualUserMapper;

    @Resource
    private AreaCodeMapper areaCodeMapper;

    @Resource
    private AliyunOSSService aliyunOSSService;

    @Resource
    private VirtualUserService virtualUserService;

    @Override
    public PageWarper<ForumPost> getApproveList(ForumPostParam param) {
        if (null != param.getStatus() && 0 == param.getStatus()) {
            param.setStatus(3);
        }
        PageWarper<ForumPost> forumList = new PageWarper<>(forumPostMapper.getList(param));

        if (CollectionUtils.isNotEmpty(forumList.getList())) {
            for (ForumPost forumPost : forumList.getList()) {
                completePostInfo(forumPost);
            }
        }

        return forumList;
    }

    @Override
    public ForumPost selectByPrimaryKey(Long id) {
        ForumPost forumPost = forumPostMapper.selectByPrimaryKey(id);

        if (forumPost != null) {
            completePostInfo(forumPost);
            if (StringUtils.isNotEmpty(forumPost.getAreaCode())) {
                forumPost.setDeliveryType(1);
            } else {
                forumPost.setDeliveryType(0);
            }
            if (forumPost.getEditorMessageId() != null) {
                EditorMessage editorMessage = editorMessageMapper.selectByPrimaryKey(forumPost.getEditorMessageId());
                if (editorMessage != null) {
                    forumPost.setEditorMessageName(editorMessage.getTemplateName());
                }
            }
            VirtualUserQueryParam virtualUserQueryParam = new VirtualUserQueryParam();
            virtualUserQueryParam.setId(forumPost.getUserId());
            List<VirtualUserOverviewDTO> virtualUserList = virtualUserService.list(virtualUserQueryParam);
            if (CollectionUtils.isNotEmpty(virtualUserList)) {
                forumPost.setUserInfo(virtualUserList.get(0).getUserInfo());
            }
        }

        return forumPost;
    }

    private void completePostInfo(ForumPost forumPost) {
        if (StringUtils.isNotEmpty(forumPost.getAreaCode())) {
            String[] areaCodeArray = forumPost.getAreaCode().split(",");
            List<AreaCode> areaCodeList = areaCodeMapper.findListByCode(areaCodeArray);
            if (CollectionUtils.isNotEmpty(areaCodeList)) {
                forumPost.setAreaDetail(JSONObject.toJSONString(areaCodeList));
            }
        }
        forumPost.setForum(forumMapper.selectByPrimaryKey(forumPost.getForumId()));
        forumPost.setTopicList(topicMapper.getListByPostId(forumPost.getId()));
        if (forumPost.getUserId() != null) {
            forumPost.setUserState(userMapper.getStateById(forumPost.getUserId()));
        }
    }

    @Override
    public int approve(String ids, Byte status, String comment) {
        List<Long> idList = convertStringToList(ids);
        if (CollectionUtils.isEmpty(idList)) {
            return 0;
        }

        for (Long id : idList) {
            ForumPost forumPost = this.forumPostMapper.selectByPrimaryKey(id);
            if (forumPost == null) {
                continue;
                //return 0;
            }

            if ((byte) 0 == status) {
                //审核拒绝
                forumPost.setStatus((byte) 3);
                this.forumPostMapper.updateByIdPartSelective(forumPost);
                //去除用户置顶帖子
                this.newsRecommendIntegrationService.cleanUserTop(forumPost.getUserId(), forumPost.getId());
            } else {
                //审核通过
                forumPost.setStatus((byte) 1);
                logger.debug("当前帖子[{}]审核通过：更新的信息为：[{}]", id, JSON.toJSONString(forumPost));
                this.forumPostMapper.updateByIdPartSelective(forumPost);

                //更新推荐标签
                this.forumPostMapper.deletePostTag(forumPost.getId());
                savePostTag(forumPost);

                //增加点击数任务
                addPostClickJob(forumPost.getId());

                //完成任务
                //completeTask(forumPost.getId(), forumPost.getUserId());

                //虚拟用户点赞
                addPostLike(forumPost, 5);

            }

            this.forumPostMapper.addApproveHistory(sequenceCreater.nextLongId(), id, status, comment, new Date());
        }

        return 1;
    }

    /**
     * 帖子添加虚拟用户点赞
     *
     * @param forumPost
     * @param num
     */
    private void addPostLike(ForumPost forumPost, Integer num) {
        List<VirtualUser> virtualUsers = virtualUserMapper.selectRandModel(num);
        ArrayList<ForumPostLike> list = Lists.newArrayList();
        for (VirtualUser virtualUser : virtualUsers) {
            Calendar calendar = Calendar.getInstance();
            //随机时间生成马甲号点赞
            int amount = (int) (1 + Math.random() * (120));
            calendar.add(Calendar.MINUTE, amount);
            ForumPostLike postLike = ForumPostLike.builder()
                    .addTime(calendar.getTime())
                    .headImg(virtualUser.getHeadImg())
                    .id(nextId())
                    .isShow((byte) 0)
                    .isVest((byte) 1)
                    .postId(forumPost.getId())
                    .type((byte) 1)
                    .userId(virtualUser.getId())
                    .userNickname(virtualUser.getNickname())
                    .build();
            list.add(postLike);
        }
        MybatisBatchBuilder.create(ForumPostLikeMapper.class, list).sessionTemplateName("newsSessionTemplate").run(ForumPostLikeMapper::insertSelective);
    }


    public void addPostClickJob(Long postId) {
        //添加24小时点击数增加定时任务
        AddPostClickCountParam param = new AddPostClickCountParam();
        param.setPostId(postId);
        param.setClickCount(randomClickCount());
        quartzIntegrationService.createPostClickTask(param);
    }

    @Override
    public int saveOrUpdate(ForumPost forumPost) {
        //id必传
        if (null == forumPost.getId()) {
            return 0;
        }

        if (StringUtils.isBlank(forumPost.getAreaCode())) {
            forumPost.setAreaCode(null);
        }

        User user = userMapper.selectByUserId(forumPost.getUserId());
        if (null != user) {
            forumPost.setUserImg(user.getHeadImg());
            forumPost.setUserName(user.getNickname());
        }

        this.analyzeContent(forumPost);
        if (StringUtils.isNotEmpty(forumPost.getCoverList())) {
            forumPost.setCoverList(JSON.toJSONString(forumPost.getCoverList().split(",")));
        }


        int update;
        ForumPost existedForumPost = this.forumPostMapper.selectByPrimaryKey(forumPost.getId());
        logger.debug("帖子新增或者更新，参数:[{}],原有数据:[{}]",JSONObject.toJSONString(forumPost),JSONObject.toJSONString(existedForumPost));
        if (null == existedForumPost) {
            forumPost.setCreateTime(new Date());
            forumPost.setClickCount(randomClickCount());
            try {
                forumPost.setCreator(Long.valueOf(WebUtils.getCurrentUserId()));
            } catch (NumberFormatException e) {
                forumPost.setCreator(forumPost.getUserId());
            }
            forumPost.setContent(forumPost.getContent());
            update = this.forumPostMapper.insertSelective(forumPost);
            if (forumPost.getStatus() == 1) {
                addPostLike(forumPost, 5);
            }
        } else {
            //防止H5将审核通过的帖子设置为未审核状态，如果原库中是<正常显示>的状态，那就不动它
            if (existedForumPost.getStatus() == 1){
                forumPost.setStatus((byte) 1);
            }
            update = this.forumPostMapper.updateByIdPartSelective(forumPost);
            //帖子审核通过给用户发送推送,添加小红花
            if (forumPost.getStatus() == 1) {
                String foruPostTitle = getForumPostTitle(forumPost);
                //增加用户小红花
                addUserGold(forumPost, existedForumPost, foruPostTitle);
                //精华帖、现金帖推送、爆料贴推送
                pushMsg(forumPost, existedForumPost, foruPostTitle);
            }
			//帖子加精并且审核通过加入推荐库
			updateRecommend(forumPost);
        }

        this.forumPostMapper.batchDeleteTopic(forumPost.getId());
        if (CollectionUtils.isNotEmpty(forumPost.getTopicIdList())) {
            List<PostTopicDTO> list = new ArrayList<>();
            for (Long topicId : forumPost.getTopicIdList()) {
                PostTopicDTO postTopicDTO = new PostTopicDTO();
                postTopicDTO.setId(sequenceCreater.nextLongId());
                postTopicDTO.setPostId(forumPost.getId());
                postTopicDTO.setTopicId(topicId);
                list.add(postTopicDTO);
            }
            this.forumPostMapper.batchInsertTopic(list);
        }

        this.forumPostMapper.deletePostTag(forumPost.getId());
        savePostTag(forumPost);

        return update;
    }

    private String getForumPostTitle(ForumPost forumPost) {
        String forumTitle = forumPost.getTitle();
        if (StringUtils.isNotBlank(forumTitle) && forumTitle.length() > 10) {
            forumTitle = forumTitle.substring(0, 10) + "...";
        } else if (StringUtils.isBlank(forumTitle)) {
            forumTitle =
                    forumPost.getTextField().length() > 10 ? forumPost.getTextField().substring(0, 10) + "..." : forumPost.getTextField();
        }
        return forumTitle;
    }


    /**
     * 帖子被选为精华或爆料时,给用户增加小红花
     *
     * @param forumPost
     * @param existedForumPost
     */
    private void addUserGold(ForumPost forumPost, ForumPost existedForumPost, String forumTitle) {
        String content;
        //帖子加精
        if (existedForumPost.getIsBrilliant() != null && existedForumPost.getIsBrilliant() == 0
                && forumPost.getIsBrilliant() != null && forumPost.getIsBrilliant() == 1) {
//            Integer amount = userAccountMapper.getUserPostGold(forumPost.getUserId(), forumPost.getId(), "BRILLIANT_POST_AWARD");
//            if (null == amount || 0 == amount) {
                AccountGoldParam param = new AccountGoldParam();
                param.setUserId(forumPost.getUserId());
                param.setGold(40);
                param.setGoldType("USABLE_GOLD");
                param.setGoldFlowType("BRILLIANT_POST_AWARD");
                param.setAddTotal(false);
                param.setRelationId(forumPost.getId());
                content = "你发布的【" + forumTitle + "】被加精";
                param.setContent(content);
                userAccountIntegrationService.addGold(param);
//            }
        }
        //爆料贴
        if (existedForumPost.getIsBroke() != null && existedForumPost.getIsBroke() == 0
                && forumPost.getIsBroke() != null && forumPost.getIsBroke() == 1) {
            AccountGoldParam param = new AccountGoldParam();
            param.setUserId(forumPost.getUserId());
            param.setGold(50);
            param.setGoldType("USABLE_GOLD");
            param.setGoldFlowType("BROKE_POST");
            param.setAddTotal(false);
            param.setRelationId(forumPost.getId());
            content = "你发布的【" + forumTitle + "】被选为爆料";
            param.setContent(content);
            userAccountIntegrationService.addGold(param);
        }
    }

    @Override
    public void dealImg(Document document) {
        Elements imag = document.select("img");
        for (Element el : imag) {
            String src = el.attr("src");
            if (StringUtils.isBlank(src)) {
                continue;
            }
            if (!src.contains("wstong.com")) {
                String path = uploadImgToOssBySrc(src);
                el.attr("src", path);
            }
        }
    }

    private String uploadImgToOssBySrc(String src) {
        final RestTemplate template = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        HttpEntity<Resource> httpEntity = new HttpEntity<Resource>(headers);
        ResponseEntity<byte[]> response = template.exchange(src, HttpMethod.GET, httpEntity, byte[].class);
        int i = src.lastIndexOf("/");
        String fileName = src.substring(i + 1);
        fileName = RandomStringUtils.random(8, true, false) + fileName;
        if (!fileName.contains(".")) {
            fileName = fileName + ".png";
        }
        String upload = aliyunOSSService.upload(response.getBody(), fileName);
        return upload;
    }

    @Override
    public int deleteOrRecover(String ids, Byte status, Byte deductGold) {
        List<Long> idList = convertStringToList(ids);
        if (CollectionUtils.isEmpty(idList)) {
            return 0;
        }

        for (Long id : idList) {
            ForumPost forumPost = this.forumPostMapper.selectByPrimaryKey(id);
            if (forumPost == null) {
                return 0;
            }
            forumPost.setStatus(status);
            this.forumPostMapper.updateByIdPartSelective(forumPost);

            //this.forumPostMapper.deletePostTag(id);
            if ((byte) 1 == status) {
                savePostTag(forumPost);
            } else {
                userMapper.minusPostNum(forumPost.getUserId());

                if (null != deductGold && (byte) 1 == deductGold) {
                    Integer goldNum = userAccountIntegrationService.countGoldByPostId(id, forumPost.getUserId());
                    if (null != goldNum && goldNum > 0) {
                        AccountGoldParam param = new AccountGoldParam();
                        param.setUserId(forumPost.getUserId());
                        param.setGold(-goldNum);
                        param.setGoldType("USABLE_GOLD");
                        param.setGoldFlowType("TASK_POST_DELETE");
                        param.setAddTotal(false);
                        param.setRelationId(id);
                        userAccountIntegrationService.addGold(param);
                    }
                }
                //去除用户置顶帖子
                this.newsRecommendIntegrationService.cleanUserTop(forumPost.getUserId(), forumPost.getId());
                //删除推荐库中的内容
                this.mixedRecommendPoolMapper.deleteByPrimaryKey(id);
            }
        }

        return 1;
    }

    @Override
    public Long getCreateId() {
        return newsSeqComponent.getPostId();
    }

    @Override
    public List<ForumPostApproveHistory> getApproveHistoryList(Long id, Integer action) {
        return forumPostMapper.getApproveHistoryList(id, action);
    }

    /**
     * 解析帖子内容
     */
    private void analyzeContent(ForumPost forumPost) {
        if (StringUtils.isNotBlank(forumPost.getContent())) {
            //提取视频和图片
            List<PostImg> postImgList = new ArrayList<>();
            List<String> imgList = new ArrayList<>();
            String content = extractVideoAndImgFromContent(forumPost.getContent(), postImgList, imgList);

            List<PostImg> postImgTempList = imgList.stream().map(PostImg::buildImg).collect(Collectors.toList());
            postImgList.addAll(postImgTempList);

            forumPost.setContent(content);
            forumPost.setImgList(JSONObject.toJSONString(postImgList));

            //提取文案
            String text = content.replaceAll("<.*?>", "");
            forumPost.setTextField(text);
        }
    }

    @Override
    public String extractVideoAndImgFromContent(String content, List<PostImg> postImgList, List<String> imgList) {
        //提取HTTP地址
        Document document = Jsoup.parse(content);
        document.outputSettings().prettyPrint(true).indentAmount(1);
        //先处理内容中的网络图片
        dealImg(document);

        //处理视频
        Elements elements = document.select("video");
        if (null != elements) {
            for (Element element : elements) {
                String src = element.attr("src");
                if (org.apache.commons.lang.StringUtils.isBlank(src)) {
                    continue;
                }

                String poster = element.attr("poster");
                if (StringUtils.isEmpty(poster)) {
                    String url = src;
                    int lastIndex = src.lastIndexOf("?");
                    if (-1 != lastIndex) {
                        url = src.substring(0, lastIndex);
                    }
                    String baseName = FilenameUtils.getBaseName(url);

                    KeyGenerator videoCacheKey = DefaultKeyGenerator.build("cache", "static", "videoinfo");
                    Map<String, Object> videoCacheInfo = redisHashMapAdapter.get(videoCacheKey, baseName, Map.class);
                    if (videoCacheInfo != null && !videoCacheInfo.isEmpty()) {
                        String size = videoCacheInfo.get("size") == null ? "0" : videoCacheInfo.get("size").toString();
                        String duration = videoCacheInfo.get("duration") == null ? "0" : videoCacheInfo.get("duration").toString();
                        String imgUrl = videoCacheInfo.get("imgUrl") == null ? "" : videoCacheInfo.get("imgUrl").toString();
                        PostImg img = new PostImg();
                        img.setType("VIDEO");
                        img.setImgUrl(imgUrl);
                        img.setSize(size);
                        img.setDuration(Long.valueOf(duration));
                        img.setVideoUrl(src);
                        postImgList.add(img);

                        element.attr("poster", img.getImgUrl());
                        element.attr("size", size);
                        element.attr("duration", duration);
                        logger.debug("video标签经处理后:{}", element.text());
                    }
                } else {
                    PostImg img = new PostImg();
                    img.setType("VIDEO");
                    img.setImgUrl(element.attr("poster"));
                    img.setVideoUrl(element.attr("src"));
                    img.setSize(element.attr("size") == null ? "0" : element.attr("size"));
                    img.setDuration(element.attr("duration") == null ? 0 : Long.valueOf(element.attr("duration")));
                    postImgList.add(img);
                }
            }
        }

        //处理图片
        Elements imgElements = document.select("img");
        if (null != imgElements) {
            for (Element element : imgElements) {
                String src = element.attr("src");
                if (org.apache.commons.lang.StringUtils.isBlank(src)) {
                    src = element.attr("data-src");
                    if (org.apache.commons.lang.StringUtils.isBlank(src)) {
                        continue;
                    }
                }
                imgList.add(src);
            }
        }

        return document.body().html().replace("\n", "");
    }

    @Override
    public Json transformPost2News(Long id) {
        ForumPost forumPost = forumPostMapper.selectByPrimaryKey(id);
        if (StringUtils.isEmpty(forumPost.getAreaCode())) {
            return ResultUtil.genFailedResult("帖子投放区域为'全国'，不支持转本地新闻");
        }
        NewsAddParam newsAddParam = new NewsAddParam();
        newsAddParam.setId(newsSeqComponent.getNewsId());
        if (StringUtils.isNotBlank(forumPost.getTitle())) {
            newsAddParam.setTitle(forumPost.getTitle());
        } else {
            if (forumPost.getTextField().length() > 10) {
                newsAddParam.setTitle(forumPost.getTextField().substring(0, 10));
            } else {
                newsAddParam.setTitle(forumPost.getTextField());
            }
        }
        newsAddParam.setContent(forumPost.getContent());

        String coverList = forumPost.getCoverList();
        if (StringUtils.isNotEmpty(coverList)) {
            List<String> list = JSONObject.parseArray(coverList, String.class);
            newsAddParam.setCoverList(StringUtils.join(list, ","));
        }
        newsAddParam.setAuthor(forumPost.getUserName());
        newsAddParam.setKindId(0);
        newsAddParam.setStatus(NewsStatusEnum.ENABLE.getCode());
        if (null != forumPost.getPublishTime()) {
            if (new Date().before(forumPost.getPublishTime())) {
                newsAddParam.setPublishTime(forumPost.getPublishTime());
                newsAddParam.setStatus(NewsStatusEnum.UNPUBLISHED.getCode());
            }
        }
        newsAddParam.setTop((byte) 1);
        newsAddParam.setHot((byte) 1);
        newsAddParam.setIsBootDownload((byte) 0);
        if (StringUtils.isNotEmpty(forumPost.getAreaCode())) {
            newsAddParam.setAreaCodes(forumPost.getAreaCode());
            newsAddParam.setDeliveryType(1);
        } else {
            newsAddParam.setAreaCodes(null);
            newsAddParam.setDeliveryType(0);
        }
        newsAddParam.setKindTop((byte) 1);
        newsAddParam.setIssueTime(forumPost.getDisplayTime());
        newsAddParam.setReviewStatus(NewsStatusEnum.UNREVIEWED.getCode());
        newsAddParam.setEnablePlaceholder((byte) 0);
        newsAddParam.setEditorMessageId(forumPost.getEditorMessageId());
        newsAddParam.setEditorMessage(forumPost.getEditorMessage());
        return adminNewsService.addNews(newsAddParam);
    }

    //推送消息
    private void pushMsg(ForumPost forumPost, ForumPost existedForumPost, String forumTitle) {
        //精华帖推送
        if (existedForumPost.getIsBrilliant() != null && existedForumPost.getIsBrilliant() == 0
                && forumPost.getIsBrilliant() != null && forumPost.getIsBrilliant() == 1) {

            String content = "恭喜！你发布的【" + forumTitle + "】被加精，奖励你40朵小红花，你的内容将会被更多人看到哦~";
            PushMessage message = getPushMessage(PushMessageEnum.ESSENCE_POST, forumPost, content);
            this.pushMsgIntegService.pushMsg(message);
        }
        //现金帖推送
        if (existedForumPost.getIsCash() != null && existedForumPost.getIsCash() == 0
                && forumPost.getIsCash() != null && forumPost.getIsCash() == 1) {
            String content = "速来领钱！你发布的【" + forumTitle + "】获得了现金奖励，请快快联系我们领取！";
            PushMessage message = getPushMessage(PushMessageEnum.CASH_POST, forumPost, content);
            this.pushMsgIntegService.pushMsg(message);
        }

        //爆料贴推送
        if (existedForumPost.getIsBroke() != null && existedForumPost.getIsBroke() == 0
                && forumPost.getIsBroke() != null && forumPost.getIsBroke() == 1) {
            String content = "恭喜！你发布的【" + forumTitle + "】被选为爆料内容，奖励你50朵小红花。";
            PushMessage message = getPushMessage(PushMessageEnum.BROKE_POST, forumPost, content);
            this.pushMsgIntegService.pushMsg(message);
        }
    }

    /**
     * 获得帖子推送对象
     *
     * @param pushMessageEnum
     * @param forumPost
     * @param content
     * @return
     */
    private PushMessage getPushMessage(PushMessageEnum pushMessageEnum, ForumPost forumPost, String content) {
        PushPayloadInfo info = PushPayloadInfo.build(pushMessageEnum);
        Long msgId = nextId();
        info.setMsgId(msgId);
        info.addExtend("msgId", msgId);
        info.addExtend("url", bizConfigProperties.getH5ServerHost() + "/servicePrize.html?areaCode=" + forumPost.getAreaCode());
        info.addExtend("postId", forumPost.getId());
        PushMessage message = PushMessage.build();
        message.setTitle("");
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle(forumPost.getUserId()));
        message.setPayloadInfo(info);
        return message;
    }

    //获取分词标签并保存
    public void savePostTag(ForumPost forumPost) {
        PendingContent pendingContent = new PendingContent();
        pendingContent.setTitle(forumPost.getTitle());
        pendingContent.setContent(forumPost.getContent());
        ResponseEntity<List<Keyword>> responseEntity = newsSyncService.analysisContent(pendingContent);
        if (responseEntity.getStatusCode().isError()) {
            return;
        }

        List<Keyword> tagList = responseEntity.getBody();
        if (CollectionUtils.isNotEmpty(tagList)) {
            for (Keyword keyword : tagList) {
                PostTag postTag = new PostTag();
                postTag.setId(sequenceCreater.nextLongId());
                postTag.setName(keyword.getName());
                postTag.setTagType(NewsTagTypeEnum.TITLE_TAG.getCode());
                postTag.setWeight(keyword.getTfidfvalue());
                postTag.setPostId(forumPost.getId());
                postTag.setTagId(commonTagService.saveAndGetTag(keyword.getName()));
                forumPostMapper.savePostTag(postTag);
            }
        }
    }

    //更新推荐池内容
    private void updateRecommend(ForumPost forumPost) {
        MixedRecommendPool mixedRecommendPool = new MixedRecommendPool();
        mixedRecommendPool.setId(forumPost.getId());
        mixedRecommendPool.setTitle(forumPost.getTitle());
        mixedRecommendPool.setIssueTime(forumPost.getDisplayTime());
        mixedRecommendPool.setPublishTime(forumPost.getPublishTime());
        if (StringUtils.isNotBlank(forumPost.getAreaCode())) {
            mixedRecommendPool.setAreaDetail(forumPost.getAreaCode());
        } else {
            mixedRecommendPool.setAreaDetail(null);
        }
        mixedRecommendPool.setOrigin("1");
        Byte isBrilliant = forumPost.getIsBrilliant();
        Byte status = forumPost.getStatus();
        MixedRecommendPool result = mixedRecommendPoolMapper.selectByPrimaryKey(forumPost.getId());
        //审核通过状态
        if (status == 1) {
            if (Objects.nonNull(result)) {
                Byte auto = result.getAuto();
                if (isBrilliant == 0 && (Objects.isNull(auto) || auto == 0)) {
                    //当推荐池是自动加入时,取消精华帖删除推荐池数据
                    mixedRecommendPoolMapper.deleteByPrimaryKey(result.getId());
                } else {
                    //更新推荐池内容
                    if (Objects.isNull(forumPost.getRecommendTop()) || forumPost.getRecommendTop() == 0) {
                        result.setTop((byte) 1);
                        result.setTopEffectiveTime(null);
                        result.setTopExpireTime(null);
                    } else if (forumPost.getRecommendTop() == 1) {
                        result.setTop((byte) 2);
                        result.setTopEffectiveTime(forumPost.getRecommendStartTime());
                        result.setTopExpireTime(forumPost.getRecommendExpireTime());
                    }
                    mixRecommendPoolService.updateMixRecommend(mixedRecommendPool, result);
                }
            } else {
                //精华帖并且审核通过加入推荐库
                if (isBrilliant == 1) {
                    Date currentTime = new Date();
                    mixedRecommendPool.setAddTime(currentTime);
                    mixedRecommendPool.setModifyTime(currentTime);
                    mixedRecommendPool.setStatus((byte) 1);
                    mixedRecommendPool.setAuto((byte) 1);
                    mixedRecommendPool.setWeight(-1);
                    mixedRecommendPool.setTop((byte) 1);
                    mixedRecommendPool.setAreaDetail(forumPost.getAreaCode());
                    mixedRecommendPool.setAuto((byte) 0);
                    mixedRecommendPool.setId(forumPost.getId());
                    mixedRecommendPool.setPublishTime(forumPost.getPublishTime());
                    if (Objects.nonNull(forumPost.getRecommendTop())) {
                        if (forumPost.getRecommendTop() == 1) {
                            mixedRecommendPool.setTopEffectiveTime(forumPost.getRecommendStartTime());
                            mixedRecommendPool.setTop((byte) 2);
                            mixedRecommendPool.setTopExpireTime(forumPost.getRecommendExpireTime());
                        } else if (forumPost.getRecommendTop() == 0) {
                            mixedRecommendPool.setTop((byte) 1);
                            mixedRecommendPool.setTopEffectiveTime(null);
                            mixedRecommendPool.setTopExpireTime(null);
                        }
                    }
                    mixedRecommendPool.setRecommendTime(new Date());
                    mixedRecommendPool.setOptimizationNotice((byte) 0);
                    mixedRecommendPoolMapper.insertSelective(mixedRecommendPool);
                }
            }

        }
        //删除状态
        if (forumPost.getStatus() == 3 || forumPost.getStatus() == 4) {
            if (Objects.nonNull(result)) {
                mixedRecommendPoolMapper.deleteByPrimaryKey(result.getId());
            }
        }
    }

    /**
     * 完成任务
     *
     * @param id
     * @param userId
     */
    public void completeTask(Long id, Long userId) {
        if (null == id || null == userId) {
            return;
        }

        logger.info("用户[{}]的帖子[{}]审核通过----- 完成任务添加金币", userId, id);

        //首次发帖
        NewsCompleTaskDTO newsCompleTaskDTO = missionIntegrationService.compleTask(userId, "TASK_FIRST_POST_INTIVATION", id.toString());
        //日常发帖
        if (null == newsCompleTaskDTO || null == newsCompleTaskDTO.getGoldNum() || 0L == newsCompleTaskDTO.getGoldNum()) {
            Integer firstAmount = userAccountMapper.getUserPostGold(userId, id, "TASK_FIRST_POST_INTIVATION");
            Integer amount = userAccountMapper.getUserPostGold(userId, id, "TASK_POST_INTIVATION");
            if ((null == firstAmount || 0 == firstAmount) && (null == amount || 0 == amount)) {
                missionIntegrationService.compleTask(userId, "TASK_POST_INTIVATION", id.toString());
            }
        }

    }

    private List<Long> convertStringToList(String s) {
        List<Long> result = new ArrayList<>();
        if (StringUtils.isNotBlank(s)) {
            try {
                String[] sa = s.split(",");
                for (String i : sa) {
                    result.add(Long.valueOf(i));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        return result;
    }

    private long randomClickCount() {
        return 2000L + new Random().nextInt(4000);
    }

}
