package com.bxm.localnews.admin.service.news;

import com.bxm.localnews.admin.dto.ContentDTO;
import com.bxm.localnews.admin.enums.ShowLevelEnum;
import com.bxm.localnews.admin.param.*;
import com.bxm.localnews.admin.vo.News;
import com.bxm.localnews.admin.vo.NewsKind;
import com.bxm.localnews.admin.vo.NewsOverView;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * @author zhaoyadong 2018/10/16 9:15
 * @desc
 */
public interface AdminNewsService {

    /**
     * 查询新闻
     * @param newsParam
     * @return 分页结果
     */
    PageWarper<NewsOverView> queryNews(NewsParam newsParam);

    /**
     * 更新新闻
     * @param news
     * @return
     */

    int updateByPrimaryKeySelective(News news);

    /**
     * 更新新闻状态
     * @param ids    新闻的id数组
     * @param status 状态
     * @return
     */
    int updateNewsStatusByIds(String[] ids, Byte status);

    /**
     * 获取新闻详情
     * @param id
     * @return
     */
    News selectByPrimaryKey(Long id);

    /**
     * 新增新闻-走数据同步
     * @param newsParam
     * @return
     */
    Json addNews(NewsAddParam newsParam);

    /**
     * 更新新闻-走数据同步
     * @param newsUpdateParam
     * @return
     */
    Json updateNews(NewsUpdateParam newsUpdateParam);

    /**
     * 获得所有的频道
     * @return
     */
    List<NewsKind> getAllKind();

    /**
     * 设置标签
     * @param showLevelEnum
     * @param id
     * @return
     */
    Json settingLevel(ShowLevelEnum showLevelEnum, Long id);

    /**
     * 根据url抓取文章内容
     * @param param
     * @return
     */
    ContentDTO getSpiderContent(CrawlingParam param);

    /**
     * 对本地新闻的审核
     * @param id
     * @param review
     */
    void review(Long id, Byte review);

    /**
     * 对本地新闻的审核（批量）
     * @param ids
     * @param review
     */
    void batchReview(String ids, Byte review);

    /**
     * 得到新增新闻的id
     * @return
     */
    Long getCreateId();


    /**
     * 新闻添加到推荐池
     * @param mixPoolParam
     * @return
     */

    int addNewsToMixRecommendPool(MixPoolParam mixPoolParam);

    int deleteNewsById(Long id);
}
