package com.bxm.localnews.admin.service.news.impl;

import com.bxm.localnews.admin.convert.impl.CommentReplyConverter;
import com.bxm.localnews.admin.domain.VirtualUserMapper;
import com.bxm.localnews.admin.integration.NewsIntegrationService;
import com.bxm.localnews.admin.param.CommentReplyParam;
import com.bxm.localnews.admin.param.NewsReplyOriginalParam;
import com.bxm.localnews.admin.param.NewsReplyParam;
import com.bxm.localnews.admin.service.news.AdminNewsReplyService;
import com.bxm.localnews.admin.vo.Forum;
import com.bxm.localnews.admin.vo.NewsReply;
import com.bxm.localnews.admin.vo.VirtualUser;
import com.bxm.localnews.news.domain.*;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.vo.PageWarper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Objects;

@Service
public class AdminNewsReplyServiceImpl extends BaseService implements AdminNewsReplyService {

    @Autowired
    private VirtualUserMapper virtualUserMapper;

    @Autowired
    private NewsReplyMapper newsReplyMapper;

    @Autowired
    private AdminNewsMapper newsMapper;

    @Autowired
    private UserReplyMapper userReplyMapper;

    @Autowired
    private ForumPostMapper forumPostMapper;

    @Autowired
    private CommentReplyConverter commentReplyConverter;

    @Autowired
    private NewsIntegrationService newsIntegrationService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void doGenerateReply(NewsReplyOriginalParam newsReplyOriginalParam) {
        List<VirtualUser> virtualUserList =virtualUserMapper.selectByModel(new VirtualUser());
        if (CollectionUtils.isEmpty(virtualUserList)) {
            return ;
        }
        int userSize = virtualUserList.size();

        long startTime = newsReplyOriginalParam.getStartTime().getTime();
        long endTime = newsReplyOriginalParam.getEndTime().getTime();

        if (startTime>endTime) {
            return;
        }

        String newsId = newsReplyOriginalParam.getNewsId().toString();

        List<NewsReplyOriginalParam.Reply> replyList = newsReplyOriginalParam.getList();
        for (NewsReplyOriginalParam.Reply reply:replyList) {
            int index = (int) (Math.random()* userSize);
            VirtualUser virtualUser = virtualUserList.get(index);
            long indexTime = RandomUtils.nextLong(startTime,endTime);

            NewsReply newsReply = new NewsReply();
            newsReply.setAddTime(new Date(indexTime));
            newsReply.setDeleteFlag((byte) 0);
            newsReply.setHeadImg(virtualUser.getHeadImg());
            newsReply.setId(nextSequence());
            newsReply.setLevel((byte) 0);
            newsReply.setLikeCount(0);
            newsReply.setNewsId(newsReplyOriginalParam.getNewsId());
            newsReply.setReplyContent(reply.getContent());
            //如果是帖子
            if (newsId.startsWith("4") && newsId.length() == 16) {
                newsReply.setType((byte) 3);
            //如果是新闻
            } else {
                newsReply.setType((byte) 1);
            }
            newsReply.setParentId(0L);
            //都设置为待展示，等待扫描
            newsReply.setStatus((byte) 0);
            newsReply.setUserId(virtualUser.getId());
            newsReply.setUserNickname(virtualUser.getNickname());
            newsReply.setInteractiveCount(0);
            newsReply.setRootId(0L);
            newsReplyMapper.insertSelective(newsReply);
            userReplyMapper.insertUserReplySelective(newsReply);
        }

        int count = newsReplyMapper.count(newsReplyOriginalParam.getNewsId());
        logger.info("虚拟评论生成，已有评论数:{},新闻/帖子id:{}",count,newsReplyOriginalParam.getNewsId());
        //如果是帖子
        if (newsId.startsWith("4") && newsId.length() == 16) {
            forumPostMapper.updateComment(newsReplyOriginalParam.getNewsId(),count);
        //如果是新闻
        } else {
            newsMapper.updateComment(newsReplyOriginalParam.getNewsId(),count);
        }
    }

    @Override
    public void delReply(Long id,Long newsId) {
        NewsReply newsReply = newsReplyMapper.selectByPrimaryKey(id, newsId);
        if (newsReply != null) {
            newsReplyMapper.deleteByPrimaryKey(id, newsId);
            userReplyMapper.deleteUserReplyByPrimaryKey(id, newsReply.getUserId());
            //删除根评论时,评论下的回复一起删除
            if (newsReply.getRootId() == 0){
                List <NewsReply> subList = newsReplyMapper.selectByRootId(newsReply.getId(),newsId);
                if (CollectionUtils.isNotEmpty(subList)){
                    subList.stream().forEach(e->{
                        newsReplyMapper.deleteByPrimaryKey(e.getId(), e.getNewsId());
                        userReplyMapper.deleteUserReplyByPrimaryKey(e.getId(), e.getUserId());
                    });
                }
            }
            int count = newsReplyMapper.count(newsId);
            logger.info("虚拟评论删除，已有评论数:{},新闻/帖子id:{}",count,newsId);
            if (newsId.toString().startsWith("4") && newsId.toString().length() == 16) {
                forumPostMapper.updateComment(newsId, count);
            } else {
                newsMapper.updateComment(newsId, count);
            }
        }
    }

    @Override
    public PageWarper<NewsReply> listNewsReply(NewsReplyParam newsReplyParam) {
        return new PageWarper<>(newsReplyMapper.queryByPageSize(newsReplyParam));
    }

    @Override
    public int doAddCommentReply(CommentReplyParam commentReplyParam) {
        //参数转化成实体
        NewsReply newsReply = commentReplyConverter.convert(commentReplyParam);
        //用户评论表
        userReplyMapper.insertUserReplySelective(newsReply);
        //新闻评论表
        int result = newsReplyMapper.insertSelective(newsReply);

        return result;
    }
}
