package com.bxm.localnews.admin.service.news.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.admin.config.BizConfigProperties;
import com.bxm.localnews.admin.constant.MarketingActivitiesDeliveryTypeEnum;
import com.bxm.localnews.admin.constant.NewsStatusEnum;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.convert.impl.NewsConverter;
import com.bxm.localnews.admin.domain.AreaCodeMapper;
import com.bxm.localnews.admin.dto.ContentDTO;
import com.bxm.localnews.admin.dto.NewsDTO;
import com.bxm.localnews.admin.dto.NewsDetailDTO;
import com.bxm.localnews.admin.enums.ShowLevelEnum;
import com.bxm.localnews.admin.integration.NewsElasticIntegrationService;
import com.bxm.localnews.admin.param.*;
import com.bxm.localnews.admin.seq.NewsSeqComponent;
import com.bxm.localnews.admin.service.NewsSyncService;
import com.bxm.localnews.admin.service.QuartzIntegrationService;
import com.bxm.localnews.admin.service.SpiderManageService;
import com.bxm.localnews.admin.service.forum.ForumPostService;
import com.bxm.localnews.admin.service.news.AdminNewsService;
import com.bxm.localnews.admin.service.recommend.MixRecommendPoolService;
import com.bxm.localnews.admin.service.security.BaseAdminService;
import com.bxm.localnews.admin.vo.*;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.domain.*;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.Page;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author zhaoyadong 2018/10/16 9:22
 * @desc
 */
@Service
@RefreshScope
public class AdminNewsServiceImpl extends BaseAdminService implements AdminNewsService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private NewsSeqComponent newsSeqComponent;

    private NewsKindMapper kindMapper;

    private AdminNewsMapper adminNewsMapper;

    private BizConfigProperties bizConfigProperties;

    private NewsElasticIntegrationService newsElasticIntegrationService;

    private NewsSyncService newsSyncService;

    private AreaCodeMapper areaCodeMapper;

    private RedisStringAdapter redisStringAdapter;

    private QuartzIntegrationService quartzIntegrationService;

    private SpiderManageService spiderManageService;

    private NewsConverter newsConverter;

    private  MixedRecommendPoolMapper mixedRecommendPoolMapper;

    private  ForumPostMapper forumPostMapper;

    private ForumPostService forumPostService;

    private MixRecommendPoolService mixRecommendPoolService;

    private EditorMessageMapper editorMessageMapper;

    @Autowired(required = false)
    public AdminNewsServiceImpl(AdminNewsMapper adminNewsMapper,
                                BizConfigProperties bizConfigProperties,
                                NewsElasticIntegrationService newsElasticIntegrationService,
                                NewsSeqComponent newsSeqComponent,
                                NewsKindMapper kindMapper,
                                NewsSyncService newsSyncService,
                                AreaCodeMapper areaCodeMapper,
                                RedisStringAdapter redisStringAdapter,
                                SpiderManageService spiderManageService,
                                QuartzIntegrationService quartzIntegrationService,
                                MixedRecommendPoolMapper mixedRecommendPoolMapper,
                                ForumPostMapper forumPostMapper,
                                MixRecommendPoolService mixRecommendPoolService,
                                ForumPostService forumPostService,
                                NewsConverter newsConverter,
                                EditorMessageMapper editorMessageMapper) {
        this.adminNewsMapper = adminNewsMapper;
        this.bizConfigProperties = bizConfigProperties;
        this.newsElasticIntegrationService = newsElasticIntegrationService;
        this.newsSeqComponent = newsSeqComponent;
        this.kindMapper = kindMapper;
        this.newsSyncService = newsSyncService;
        this.areaCodeMapper = areaCodeMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.quartzIntegrationService = quartzIntegrationService;
        this.spiderManageService = spiderManageService;
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
        this.forumPostMapper = forumPostMapper;
        this.mixRecommendPoolService = mixRecommendPoolService;
        this.forumPostService = forumPostService;
        this.newsConverter = newsConverter;
        this.editorMessageMapper = editorMessageMapper;
    }

    @Override
    public PageWarper<NewsOverView> queryNews(NewsParam newsParam) {
        logger.info("分页查询->NewsParam:{}", JSON.toJSON(newsParam));
        AdminNewsPageParam adminNewsPageParam = new AdminNewsPageParam();
        BeanUtils.copyProperties(newsParam, adminNewsPageParam);
        adminNewsPageParam.setKeyword(newsParam.getTitle());
        adminNewsPageParam.setAreaCode(newsParam.getAreaName());
        //从es中查询新闻
        NewsDTO pageWarper = newsElasticIntegrationService.listNews(adminNewsPageParam);

        List<NewsOverView> newsDtoList = new ArrayList<>();
        if (null != pageWarper) {
            List<com.bxm.localnews.admin.dto.NewsWarperDTO> newsList = pageWarper.getNewsList();
            for (com.bxm.localnews.admin.dto.NewsWarperDTO news : newsList) {
                NewsOverView newsDto = new NewsOverView();

                //todo 这里要做个缓存，每次都去数据库取肯定不行 [沈涛]
                if (null != news.getAreaDetail()) {
                    newsDto.setAreaDetail(getAreaDetail(news.getAreaDetail()));
                }

                //新闻详情地址
                newsDto.setLinkUrl(getH5ServerHost(news.getId(), news.getType()));

                //新闻展示标签
                newsDto.setShowLevelDetail(this.fillingShowLevelDetail(
                        news.getTop(),
                        news.getHot(),
                        news.getKindTop(),
                        news.getAreaDetail(),
                        null));

                //转换实体
                this.convertNews(news, newsDto);

                newsDtoList.add(newsDto);
            }
        }
        com.github.pagehelper.Page page = new Page(newsParam.getPageNum(), newsParam.getPageSize());
        page.setTotal(pageWarper.getTotal());
        page.addAll(newsDtoList);
        return new PageWarper<>(page);
    }

    private String getH5ServerHost(Long id, Byte type) {
        String h5ServerHost = bizConfigProperties.getH5ServerHost();
        if (type == 1 || type == 3) {
            return h5ServerHost + "/newsDetail.html?newsId=" + id + "&userId=" + "&type="
                    + type;
        }
        return null;
    }

    private String getAreaDetail(String[] areaDetailArray) {
        List<AreaCode> areaCodeList = areaCodeMapper.findListByCode(areaDetailArray);
        return JSONObject.toJSONString(areaCodeList);
    }

    private String fillingShowLevelDetail(Byte top, Byte hot, Byte kindTop, String[] areaDetailArray, String areaDetailStr) {
        List<String> showLevelDetail = new ArrayList();
        // todo 魔法值定义[沈涛]
        if (top != null && top == 2) {
            showLevelDetail.add("0");
        }
        if (hot != null && hot == 2) {
            showLevelDetail.add("1");
        }
        if (kindTop != null && kindTop == 2) {
            showLevelDetail.add("2");
        }
        if (hot != null && hot == 3) {
            showLevelDetail.add("3");
        }
        if (StringUtils.isNotEmpty(areaDetailStr) && ArrayUtils.isNotEmpty(areaDetailArray)) {
            showLevelDetail.add("4");
        }
        if (CollectionUtils.isEmpty(showLevelDetail)) {
            showLevelDetail.add("99");
        }
        return StringUtils.join(showLevelDetail, ",");
    }

    private void convertNews(com.bxm.localnews.admin.dto.NewsWarperDTO news, NewsOverView newsDto) {
        newsDto.setAddTime(news.getAddTime());
        newsDto.setId(news.getId());
        newsDto.setIssueTime(news.getIssueTime());
        newsDto.setKindId(news.getKindId());
        newsDto.setPublishTime(news.getPublishTime());
        newsDto.setStatus((byte) news.getStatus().intValue());
        newsDto.setTitle(news.getTitle());
        newsDto.setType(news.getType());
        newsDto.setReviewStatus(news.getReviewStatus());
        newsDto.setAuthor(news.getAuthor());
        newsDto.setIsRecommend(news.getIsRecommend());
    }

    @Override
    public int updateByPrimaryKeySelective(News news) {
        return this.adminNewsMapper.updateByPrimaryKeySelective(news);
    }

    @Override
    public int updateNewsStatusByIds(String[] ids, Byte status) {
        return this.adminNewsMapper.updateNewsStatusByIds(ids, status);
    }

    @Override
    public News selectByPrimaryKey(Long id) {
        logger.debug("新闻详情es开始拉取 ");
        NewsDetailDTO newsDetailDTO = newsElasticIntegrationService.getNewsFromES(id);
        if (null == newsDetailDTO) {
            return null;
        }

        News news = new News();
        BeanUtils.copyProperties(newsDetailDTO, news);

        if (null != newsDetailDTO.getAreaDetail()) {
            news.setAreaDetail((getAreaDetail(newsDetailDTO.getAreaDetail().split(","))));
            news.setDeliveryType(1);
        } else {
            news.setDeliveryType(0);
        }

        news.setShowLevelDetail(this.fillingShowLevelDetail(
                news.getTop(),
                news.getHot(),
                news.getKindTop(),
                null,
                news.getAreaDetail()));

        news.setLinkUrl(getH5ServerHost(news.getId(), news.getType()));

        if (news.getEditorMessageId() != null) {
            EditorMessage editorMessage = editorMessageMapper.selectByPrimaryKey(news.getEditorMessageId());
            if (editorMessage != null) {
                news.setEditorMessageName(editorMessage.getTemplateName());
            }
        }

        logger.debug("新闻详情拉取完成：{}", newsDetailDTO);
        return news;
    }

    @Override
    public Json addNews(NewsAddParam newsParam) {
        News news = new News();
        news.setId(getNewsId(newsParam));
        news.setTitle(newsParam.getTitle());
        news.setAddTime(Calendar.getInstance().getTime());
        news.setIssueTime(newsParam.getIssueTime());
        news.setPublishTime(newsParam.getPublishTime());
        news.setStatus(newsParam.getStatus() == null ? NewsStatusEnum.UNPUBLISHED.getCode() : newsParam.getStatus());
        news.setDeliveryType(newsParam.getDeliveryType());
        news.setAddress("null");
        //新闻默认为1，以前还有视频和组图，现在没有了
        news.setType((byte) 1);
        news.setAuthor(newsParam.getAuthor());
        news.setKindId(newsParam.getKindId());
        news.setKindName(newsConverter.getKindName(Long.valueOf(newsParam.getKindId())));
        news.setReviewStatus(newsParam.getReviewStatus() == null ? NewsStatusEnum.AUDITED.getCode() : newsParam.getReviewStatus());
        news.setIsBootDownload(newsParam.getIsBootDownload());
        news.setEditorMessage(newsParam.getEditorMessage());
        news.setEditorMessageId(newsParam.getEditorMessageId());
        news.setEnablePlaceholder(newsParam.getEnablePlaceholder());
        news.setContent(newsParam.getContent());

        //提取内容中的视频和图片
        this.analyzeContent(news);

        //取得封面
        if (StringUtils.isNotBlank(newsParam.getCoverList())) {
            news.setCoverList(JSON.toJSONString(newsParam.getCoverList().split(",")));
        }

        //取得热门，以及热门过期时间
        news.setHot(newsParam.getHot());
        if (newsParam.getHot() == 2) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(newsParam.getIssueTime());
            calendar.add(Calendar.HOUR, 24);
            news.setHotExpireTime(calendar.getTime());
        }
        //频道是否置顶
        news.setKindTop((byte) 1);

        //推荐是否置顶
        news.setTop(newsParam.getTop());
        if (newsParam.getTop() == 2) {
            news.setTopExpireTime(newsParam.getTopExpireTime());
        }

        // 投放为区域型
        if (MarketingActivitiesDeliveryTypeEnum.AREA.getCode().equals(newsParam.getDeliveryType())) {
            if (StringUtils.isNotBlank(newsParam.getAreaCodes())) {
                news.setAreaDetail(newsParam.getAreaCodes());
            } else {
                return ResultUtil.genFailedResult("投放区域入参错误");
            }
        }

        this.newsSyncService.save(news);

        // 创建发布新闻job并清除首页置顶新闻列表缓存
        this.createPublishNewsTaskJob(news, newsParam.getAreaCodes());

        // 清除首页置顶新闻列表缓存
        this.clearRedisCacheOfTopNewsList(newsParam.getAreaCodes(), null);

        return ResultUtil.genSuccessResult();
    }

    private void analyzeContent(News news){
        //提取内容中的视频和图片
        List<PostImg> videoList = new ArrayList<>();
        List<String> imgList = new ArrayList<>();
        String content =forumPostService.extractVideoAndImgFromContent(news.getContent(), videoList, imgList);

        news.setContent(content);
        if (CollectionUtils.isNotEmpty(videoList)) {
            news.setVideoList(JSONObject.toJSONString(videoList));
        }

        if (CollectionUtils.isNotEmpty(imgList)) {
            news.setImgUrl(JSONObject.toJSONString(imgList));
        } else {
            news.setImgUrl("");
        }
    }

    private Long getNewsId(NewsAddParam newsAddParam) {
        Long id;
        if (null != newsAddParam.getId()) {
            id = newsAddParam.getId();
        } else {
            id = newsSeqComponent.getNewsId();
        }
        return id;
    }

    @Override
    public Json updateNews(NewsUpdateParam newsUpdateParam) {
        News news = adminNewsMapper.selectByPrimaryKey(newsUpdateParam.getId());
        if (news == null) {
            return ResultUtil.genFailedResult("新闻不存在");
        }

        News param = new News();
        param.setId(news.getId());
        param.setTitle(newsUpdateParam.getTitle());
        param.setReviewStatus(newsUpdateParam.getReviewStatus());
        param.setStatus(newsUpdateParam.getStatus());
        param.setAuthor(newsUpdateParam.getAuthor());
        param.setKindId(newsUpdateParam.getKindId());
        param.setKindName(newsConverter.getKindName(Long.valueOf(newsUpdateParam.getKindId())));
        param.setIsBootDownload(newsUpdateParam.getIsBootDownload());
        param.setIssueTime(newsUpdateParam.getIssueTime());
        param.setPublishTime(newsUpdateParam.getPublishTime());
        param.setEditorMessageId(newsUpdateParam.getEditorMessageId());
        param.setEditorMessage(newsUpdateParam.getEditorMessage());
        param.setEnablePlaceholder(newsUpdateParam.getEnablePlaceholder());
        param.setContent(newsUpdateParam.getContent());

        //提取内容中的视频和图片
        analyzeContent(param);

        //取得封面
        if (StringUtils.isNotBlank(newsUpdateParam.getCoverList())) {
            param.setCoverList(JSON.toJSONString(newsUpdateParam.getCoverList().split(",")));
        }

        //地区信息
        if (StringUtils.isNotBlank(newsUpdateParam.getAreaCodes())) {
            param.setAreaDetail(newsUpdateParam.getAreaCodes());
        } else {
            param.setAreaDetail(null);
        }

        //置顶与频道置顶
        param.setTop(newsUpdateParam.getTop());
        param.setKindTop(newsUpdateParam.getKindTop());
        if (newsUpdateParam.getTop() == 2) {
            if (newsUpdateParam.getReviewStatus() != 2 || newsUpdateParam.getStatus() != 1) {
                return ResultUtil.genFailedResult("亲，新闻审核状态异常或者新闻状态异常呢！");
            }
            param.setTopExpireTime(newsUpdateParam.getTopExpireTime());
        }

        //热门
        param.setHot(newsUpdateParam.getHot());
        if (newsUpdateParam.getHot() == 2) {
            if (news.getHotExpireTime() == null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(newsUpdateParam.getIssueTime());
                calendar.add(Calendar.HOUR, 24);
                param.setHotExpireTime(calendar.getTime());
            }
        }

        // 创建发布新闻job ,在更新爬过来的新闻时，不需要定时发布新闻
        if (news.getStatus().equals(NewsStatusEnum.UNPUBLISHED.getCode())) {
            if (news.getPublishTime() != null) {
                this.createPublishNewsTaskJob(news, newsUpdateParam.getAreaCodes());
            }
        }

        ResponseEntity save = this.newsSyncService.save(param);
        if (save.getStatusCode() == HttpStatus.OK){
            saveRecommendPoolAuto(param);
        }
        // 清除首页置顶新闻列表缓存
        this.clearRedisCacheOfTopNewsList(newsUpdateParam.getAreaCodes(), news.getAreaDetail());
        return ResultUtil.genSuccessResult();
    }

    private void saveRecommendPoolAuto(News param) {
        //更新推荐池内容
        MixedRecommendPool pool = mixedRecommendPoolMapper.selectByPrimaryKey(param.getId());
        if (Objects.nonNull(pool)) {
            MixedRecommendPool mixedRecommendPool = new MixedRecommendPool();
            mixedRecommendPool.setId(param.getId());
            mixedRecommendPool.setTitle(param.getTitle());
            mixedRecommendPool.setPublishTime(param.getPublishTime());
            mixedRecommendPool.setIssueTime(param.getIssueTime());
            if (Objects.nonNull(param.getTop())) {
                if (param.getTop() == 2) {
                    pool.setTop(param.getTop());
                    pool.setTopEffectiveTime(new Date());
                    pool.setTopExpireTime(param.getTopExpireTime());
                } else if (param.getTop() == 1) {
                    pool.setTop(param.getTop());
                    pool.setTopEffectiveTime(null);
                    pool.setTopExpireTime(null);
                }
            }

            mixedRecommendPool.setAreaDetail(param.getAreaDetail());
            mixRecommendPoolService.updateMixRecommend(mixedRecommendPool, pool);
        } else {
            if (param.getReviewStatus() == 2 && param.getStatus() == 1) {
                mixRecommendPoolService.addNewstToRecommendPool(param);
            }
        }
    }

    @Override
    public List<NewsKind> getAllKind() {
        return kindMapper.selectAllKinds();
    }

    @Override
    public Json settingLevel(ShowLevelEnum showLevelEnum, Long id) {
        News news = adminNewsMapper.selectByPrimaryKey(id);
        if (news == null) {
            return ResultUtil.genFailedResult("新闻不存在");
        }
        News param = new News();
        if (StringUtils.isNotBlank(news.getShowLevelDetail())) {
            String[] levels = StringUtils.split(news.getShowLevelDetail(), ",");
            List<String> levelList = new ArrayList<>(Arrays.asList(levels));
            if (!levelList.contains(showLevelEnum.getCode() + "")) {
                levelList.add(showLevelEnum.getCode() + "");
            }
            Collections.sort(levelList);
            param.setId(id);
            param.setShowLevel(Integer.parseInt(levelList.get(0)));
            param.setShowLevelDetail(StringUtils.join(levelList, ","));
            adminNewsMapper.updateByPrimaryKeySelective(param);
        } else {
            param.setId(id);
            param.setShowLevel(showLevelEnum.getCode());
            param.setShowLevelDetail(showLevelEnum.getCode() + "");
            adminNewsMapper.updateByPrimaryKeySelective(param);
        }
        return ResultUtil.genSuccessResult();
    }

    @Override
    public ContentDTO getSpiderContent(CrawlingParam param) {
        ResponseEntity<ContentDTO> contentDTOResponseEntity = spiderManageService.pageDownload(param);
        return contentDTOResponseEntity.getBody();
    }

    @Override
    public void review(Long id, Byte review) {
        News news = adminNewsMapper.selectByPrimaryKey(id);
        if (null!=news) {
            News newsParam = new News();
            newsParam.setId(id);
            newsParam.setReviewStatus(review);
            ResponseEntity save = newsSyncService.updateStatus(newsParam);
            if (review.equals(NewsStatusEnum.AUDITED.getCode()) && save.getStatusCode() == HttpStatus.OK){
                mixRecommendPoolService.addNewstToRecommendPool(news);
            }
        }
    }

    @Override
    public void batchReview(String ids, Byte review) {
        String[] idArray = ids.split(",");
        if (idArray.length > 0) {
            for (String idStr : idArray) {
                News news = adminNewsMapper.selectByPrimaryKey(Long.valueOf(idStr));
                News newsParam = new News();
                newsParam.setId(Long.valueOf(idStr));
                newsParam.setReviewStatus(review);
                ResponseEntity save = newsSyncService.updateStatus(newsParam);
                if (review.equals(NewsStatusEnum.AUDITED.getCode()) && save.getStatusCode() == HttpStatus.OK) {
                    mixRecommendPoolService.addNewstToRecommendPool(news);
                }
            }
        }
    }

    @Override
    public Long getCreateId() {
        return newsSeqComponent.getNewsId();
    }

    /**
     * 清理置顶新闻缓存基础方法
     * @param areaCodeStr
     */
    private void cleanRedisCacheOfTopNews(String areaCodeStr) {
        if (StringUtils.isNotEmpty(areaCodeStr)) {
            String[] areaCodes = areaCodeStr.split(",");
            for (String areaCode : areaCodes) {
                KeyGenerator keyGenerator = RedisConfig.TOP_NEW_OF_AREA_LIST.copy().appendKey(areaCode);
                redisStringAdapter.remove(keyGenerator);
            }
        }
    }

    /**
     * 清理置顶新闻缓存（修改更新新闻时）
     * @param newAreaCodeStr
     * @param oldAreaCodeStr
     */
    private void clearRedisCacheOfTopNewsList(String newAreaCodeStr, String oldAreaCodeStr) {
        // 删除更新后的地区置顶新闻缓存
        cleanRedisCacheOfTopNews(newAreaCodeStr);
        // 删除更新前的地区置顶新闻缓存
        cleanRedisCacheOfTopNews(oldAreaCodeStr);
        // 清除全国性置顶新闻缓存
        redisStringAdapter.remove(RedisConfig.TOP_NEW_OF_WHOLE_COUNTRY_LIST);
    }

    /**
     * 清理置顶新闻缓存（删除新闻时）
     * @param areaCodeStr
     */
    private void clearRedisCacheOfTopNewsList(String areaCodeStr) {
        // 删除地区置顶新闻缓存
        cleanRedisCacheOfTopNews(areaCodeStr);
        // 清除全国性置顶新闻缓存
        redisStringAdapter.remove(RedisConfig.TOP_NEW_OF_WHOLE_COUNTRY_LIST);
    }

    /**
     * 新闻定时任务发布
     * @param news
     * @param areaCodes
     */
    private void createPublishNewsTaskJob(News news, String areaCodes) {
        PublishNewsBuildParam param = new PublishNewsBuildParam();
        param.setAreaCodes(areaCodes);
        param.setNewsId(news.getId());
        param.setStartTime(news.getPublishTime());
        logger.debug("创建发布新闻:{}", JSON.toJSONString(param));
        quartzIntegrationService.addPublish(param);
    }

    @Override
    public int addNewsToMixRecommendPool(MixPoolParam mixPoolParam) {
        int num = 0;
        MixedRecommendPool mixedRecommendPool = new MixedRecommendPool();
        MixedRecommendPool result = mixedRecommendPoolMapper.selectByPrimaryKey(mixPoolParam.getId());
        String origin = mixPoolParam.getOrigin();
        mixedRecommendPool.setOrigin(origin);

        if (StringUtils.equals("2",origin)|| StringUtils.equals("3",origin) ){
            News news = adminNewsMapper.selectByPrimaryKey(mixPoolParam.getId());
            //新闻置顶无法加入推荐库
            if (news.getTop() == 2){
                return 0;
            }
            News newsTotle = new News();
            newsTotle.setId(mixPoolParam.getId());
            //将新闻设置为推荐
            newsTotle.setIsRecommend((byte)1);
            adminNewsMapper.updateByPrimaryKeySelective(newsTotle);
            if (Objects.isNull(result)){
                BeanUtils.copyProperties(news,mixedRecommendPool);
                num =  addMixRecommandPool(mixedRecommendPool,mixPoolParam);
            }else{
                num = updateMixRecommandPool(result,mixPoolParam);
            }

        }else if (StringUtils.equals("1",origin)){
            ForumPost forumPost = forumPostMapper.selectByPrimaryKey(mixPoolParam.getId());
            forumPost.setIsRecommend((byte) 1);
            forumPostMapper.updateByIdPartSelective(forumPost);
            if (Objects.isNull(result)){
                mixedRecommendPool.setTitle(forumPost.getTitle());
                mixedRecommendPool.setAreaDetail(forumPost.getAreaCode());
                mixedRecommendPool.setIssueTime(forumPost.getDisplayTime());
                mixedRecommendPool.setId(forumPost.getId());
                mixedRecommendPool.setPublishTime(forumPost.getPublishTime());
                mixedRecommendPool.setOptimizationNotice(mixPoolParam.getOptimizationNotice());
                mixedRecommendPool.setRecommendTime(mixPoolParam.getRecommendTime());
                num = addMixRecommandPool(mixedRecommendPool,mixPoolParam);
            }else {
                num = updateMixRecommandPool(result,mixPoolParam);
            }

            //帖子为用户创建时,调用quarz 生成定时推送帖子加入推荐库推送任务
            if (Objects.isNull(forumPost.getCreator())){
                OptimizationNoticeParam param = new OptimizationNoticeParam();
                param.setId(forumPost.getId());
                param.setStartTime(mixPoolParam.getRecommendTime());
                quartzIntegrationService.sendOptimizationNotice(param);
            }
        }
        return num;
    }

    /**
     * 添加到推荐池
     * @param mixedRecommendPool
     * @param mixPoolParam
     * @return
     */
    private int addMixRecommandPool(MixedRecommendPool mixedRecommendPool,MixPoolParam mixPoolParam){
        Date currentTime = new Date();
        mixedRecommendPool.setAddTime(currentTime);
        mixedRecommendPool.setModifyTime(currentTime);
        mixedRecommendPool.setWeight(0);
        mixedRecommendPool.setTop((byte)1);
        mixedRecommendPool.setStatus((byte)1);
        mixedRecommendPool.setRecommendTime(mixPoolParam.getRecommendTime());
        mixedRecommendPool.setOptimizationNotice(mixPoolParam.getOptimizationNotice());
        //手动添加
        mixedRecommendPool.setAuto((byte) 1);
        return   mixedRecommendPoolMapper.insertSelective(mixedRecommendPool);
    }

    /**
     * 将推荐池中中数据设置为手动推荐
     * @param result
     * @param mixPoolParam
     * @return
     */
    private int  updateMixRecommandPool(MixedRecommendPool result,MixPoolParam mixPoolParam){
        //设置为手动推荐
        result.setAuto((byte) 1);
        result.setWeight(0);
        result.setAddTime(new Date());
        result.setRecommendTime(mixPoolParam.getRecommendTime());
        result.setOptimizationNotice(mixPoolParam.getOptimizationNotice());
        return  mixedRecommendPoolMapper.updateByPrimaryKeySelective(result);
    }


    @Override
    public int deleteNewsById(Long id) {
        //删除新闻时将推荐库的内容删除
        int result = mixedRecommendPoolMapper.deleteByPrimaryKey(id);

        News oldNews = adminNewsMapper.selectByPrimaryKey(id);

        News newsParam = new News();
        newsParam.setId(id);
        newsParam.setStatus((byte) -2);
        newsSyncService.updateStatus(newsParam);

        // 清除首页置顶新闻列表缓存
        this.clearRedisCacheOfTopNewsList(oldNews.getAreaDetail());
        return result;
    }


}
