package com.bxm.localnews.admin.service.news.impl;

import com.bxm.localnews.admin.domain.LocationMapper;
import com.bxm.localnews.admin.param.MonitorTaskBuildParam;
import com.bxm.localnews.admin.param.NewsMonitorConditionParam;
import com.bxm.localnews.admin.param.NewsMonitorParam;
import com.bxm.localnews.admin.service.QuartzIntegrationService;
import com.bxm.localnews.admin.service.news.NewsMonitorService;
import com.bxm.localnews.admin.vo.NewsMonitorAreaInfoBean;
import com.bxm.localnews.admin.vo.NewsMonitorBean;
import com.bxm.localnews.admin.vo.NewsMonitorIndexBean;
import com.bxm.localnews.news.domain.NewsMonitorAreaMapper;
import com.bxm.localnews.news.domain.NewsMonitorIndexMapper;
import com.bxm.localnews.news.domain.NewsMonitorMapper;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class NewsMonitorServiceImpl extends BaseService implements NewsMonitorService {

    private NewsMonitorMapper newsMonitorMapper;

    private NewsMonitorAreaMapper newsMonitorAreaMapper;

    private NewsMonitorIndexMapper newsMonitorIndexMapper;

    private QuartzIntegrationService quartzIntegrationService;

    private LocationMapper locationMapper;

    @Autowired
    public NewsMonitorServiceImpl(NewsMonitorMapper newsMonitorMapper,
                                  NewsMonitorAreaMapper newsMonitorAreaMapper,
                                  NewsMonitorIndexMapper newsMonitorIndexMapper,
                                  QuartzIntegrationService quartzIntegrationService,
                                  LocationMapper locationMapper) {
        this.newsMonitorMapper = newsMonitorMapper;
        this.newsMonitorAreaMapper = newsMonitorAreaMapper;
        this.newsMonitorIndexMapper = newsMonitorIndexMapper;
        this.quartzIntegrationService = quartzIntegrationService;
        this.locationMapper = locationMapper;
    }

    @Override
    public PageWarper<NewsMonitorBean> queryByParam(NewsMonitorParam param) {
        return new PageWarper<>(newsMonitorMapper.queryByPage(param));
    }

    @Override
    public Message save(NewsMonitorConditionParam param) {
        Message message;
        NewsMonitorBean entity = convert(param);
        if (entity.getId() != null) {
            removeTask(param.getId());
            message = Message.build(newsMonitorMapper.update(entity));
        } else {
            entity.setId(nextId());
            message = Message.build(newsMonitorMapper.insert(entity));
        }

        saveRelation(param, entity.getId());
        createTask(entity, param.getAreaCodes());

        return message;
    }

    private NewsMonitorBean convert(NewsMonitorConditionParam param) {
        NewsMonitorBean entity = new NewsMonitorBean();
        entity.setMonitorType(param.getMonitorType());
        entity.setId(param.getId());
        entity.setGlobalFlag(param.getGlobalFlag());
        entity.setName(param.getName());
        entity.setMonitorIndexList(param.getMonitorIndexList());
        entity.setKindId(param.getKindId());

        return entity;
    }

    private void saveRelation(NewsMonitorConditionParam param, Long monitorId) {
        newsMonitorAreaMapper.removeAll(monitorId);
        String[] areaCodeArray = StringUtils.split(param.getAreaCodes(), ",");
        for (String areaCode : areaCodeArray) {
            NewsMonitorAreaInfoBean areaInfoBean = new NewsMonitorAreaInfoBean();
            areaInfoBean.setId(nextId());
            areaInfoBean.setAreaCode(areaCode);
            areaInfoBean.setConditionId(monitorId);

            newsMonitorAreaMapper.insert(areaInfoBean);
        }

        newsMonitorIndexMapper.removeAll(monitorId);

        for (NewsMonitorIndexBean indexBean : param.getMonitorIndexList()) {
            indexBean.setId(nextId());
            indexBean.setMonitorId(monitorId);
            newsMonitorIndexMapper.insert(indexBean);
        }
    }

    /**
     * 创建定时任务，用于在指定的时间进行监控记录
     * @param entity 监控任务信息
     */
    private void createTask(NewsMonitorBean entity, String areaCodes) {
        removeTask(entity.getId());

        for (NewsMonitorIndexBean indexBean : entity.getMonitorIndexList()) {
            if (NumberUtils.isDigits(indexBean.getFireTime()) && NumberUtils.toInt(indexBean.getFireTime()) <= 23) {

                MonitorTaskBuildParam param = new MonitorTaskBuildParam();
                param.setMonitorId(entity.getId());
                param.setIndexId(indexBean.getId());
                param.setFireTime(indexBean.getFireTime());
                param.setKindId(entity.getKindId());
                param.setAreaCodes(areaCodes);
                param.setName(entity.getName());
                param.setNum(indexBean.getNum());

                quartzIntegrationService.addMonitor(param);
            } else {
                logger.error("配置监控[{}]下的监控指标时间错误，错误的时间是：[{}]", entity.getName(), indexBean.getFireTime());
            }

        }
    }

    @Override
    public NewsMonitorBean get(Long id) {
        NewsMonitorBean entity = newsMonitorMapper.get(id);

        if (null == entity) {
            return new NewsMonitorBean();
        }
        List<NewsMonitorAreaInfoBean> newsMonitorAreaInfoBeanList= newsMonitorAreaMapper.queryAll(id);
        for (NewsMonitorAreaInfoBean newsMonitorAreaInfoBean:newsMonitorAreaInfoBeanList) {
            newsMonitorAreaInfoBean.setAreaName(locationMapper.selectByCode(newsMonitorAreaInfoBean.getAreaCode()).getName());
        }

        entity.setRelationAreaInfos(newsMonitorAreaInfoBeanList);
        entity.setMonitorIndexList(newsMonitorIndexMapper.queryAll(id));

        return entity;
    }

    private void removeTask(Long id) {
        List<NewsMonitorIndexBean> indexBeans = newsMonitorIndexMapper.queryAll(id);
        for (NewsMonitorIndexBean indexBean : indexBeans) {
            logger.debug("remove the monitor index : {}", indexBean.getId());
            quartzIntegrationService.removeMonitor(indexBean.getId());
        }
    }

    @Override
    public Message remove(Long id) {
        removeTask(id);
        return Message.build(newsMonitorMapper.remove(id));
    }
}
