package com.bxm.localnews.admin.service.news.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.admin.domain.LocationMapper;
import com.bxm.localnews.admin.param.NewsDetailStatisticsParam;
import com.bxm.localnews.admin.param.NewsSourceStatisticsParam;
import com.bxm.localnews.admin.service.news.NewsSourceStatisticsService;
import com.bxm.localnews.admin.vo.Location;
import com.bxm.localnews.admin.vo.NewsSourceInfoBean;
import com.bxm.localnews.news.domain.NewsStatisticsMapper;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

@Service
public class NewsSourceStatisticsServiceImpl extends BaseService implements NewsSourceStatisticsService {

    @Autowired
    private NewsStatisticsMapper newsStatisticsMapper;

    @Autowired
    private LocationMapper locationMapper;

    @Override
    public List<NewsSourceInfoBean> query(NewsSourceStatisticsParam param) {
        if ("全国".equals(param.getSource())) {
            param.setSource(null);
        }
        List<NewsSourceInfoBean> result = newsStatisticsMapper.countWithSource(param);

        for (NewsSourceInfoBean sourceInfo : result) {
            if (StringUtils.isNotEmpty(sourceInfo.getSource())) {
                String[] areaArray = sourceInfo.getSource().split(",");
                if (areaArray.length!=0) {
                    String code = areaArray[0];
                    sourceInfo.setAreaCode(code);
                    Location location = locationMapper.selectByCode(code);
                    logger.debug("根据code:[{}]获取地区信息:[{}]",code, JSONObject.toJSONString(location));
                    sourceInfo.setSource(Objects.nonNull(location) ? location.getName() : "全国");
                } else {
                    sourceInfo.setSource("全国");
                }
            }
        }

        return result;
    }

    @Override
    public List<NewsSourceInfoBean> queryDetail(NewsDetailStatisticsParam param) {
        return newsStatisticsMapper.countWithArea(param);
    }
}
