package com.bxm.localnews.admin.service.recommend;

import com.bxm.localnews.admin.dto.MixRecommandDTO;
import com.bxm.localnews.admin.param.MixPoolParam;
import com.bxm.localnews.admin.param.MixRecommandParam;
import com.bxm.localnews.admin.param.MixRecommendTopParam;
import com.bxm.localnews.admin.vo.MixedRecommendPool;
import com.bxm.localnews.admin.vo.News;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.Date;

public interface MixRecommendPoolService {
    /**
     * 推荐池分页查询
     * @param mixRecommandParam
     * @return
     */
    PageWarper<MixRecommandDTO> getPagenationList(MixRecommandParam mixRecommandParam);

    /**
     * 取消推荐
     * @param mixPoolParam
     * @return
     */
    int cancelRecommendById(MixPoolParam mixPoolParam);

    /**
     * 修改推荐池权重
     * @param mixPoolParam
     * @param weight
     * @return
     */
    int updateMixRecommandWeight(MixPoolParam mixPoolParam, Integer weight);

    /**
     * 修改推荐池中的内容
     * @param mixedRecommendPool  需要修改的字段
     * @param oldmixedRecommendPool 原始推荐池数据
     * @return
     */
    int updateMixRecommend(MixedRecommendPool mixedRecommendPool,MixedRecommendPool oldmixedRecommendPool);

    /**
     * 推荐池置顶
     * @param mixPoolParam
     * @return
     */
    int addTop(MixRecommendTopParam mixPoolParam);

    /**
     * 本地新闻通过审核时加入混合推荐池
     * @param news
     * @return
     */
    int addNewstToRecommendPool(News news);

    /**
     * 更新推荐池时间
     * @param id
     * @param recommendTime
     * @return
     */
	int doUpdateRecommandTimeById(Long id, Date recommendTime);
}
