package com.bxm.localnews.admin.service.recommend.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.admin.domain.AreaCodeMapper;
import com.bxm.localnews.admin.dto.MixRecommandDTO;
import com.bxm.localnews.admin.enums.MixRecommendEnum;
import com.bxm.localnews.admin.param.MixPoolParam;
import com.bxm.localnews.admin.param.MixRecommandParam;
import com.bxm.localnews.admin.param.MixRecommendTopParam;
import com.bxm.localnews.admin.param.OptimizationNoticeParam;
import com.bxm.localnews.admin.service.QuartzIntegrationService;
import com.bxm.localnews.admin.service.recommend.MixRecommendPoolService;
import com.bxm.localnews.admin.vo.*;
import com.bxm.localnews.news.domain.AdminNewsMapper;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.MixedRecommendPoolMapper;
import com.bxm.newidea.component.vo.PageWarper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@Service
@Slf4j
public class MixRecommendPoolServiceImpl implements MixRecommendPoolService {

    private MixedRecommendPoolMapper mixedRecommendPoolMapper;
    private AdminNewsMapper adminNewsMapper;
    private AreaCodeMapper areaCodeMapper;
    private ForumPostMapper forumPostMapper;
    private QuartzIntegrationService qartzIntegrationService;

    @Autowired
    public MixRecommendPoolServiceImpl(MixedRecommendPoolMapper mixedRecommendPoolMapper,
                                       AdminNewsMapper adminNewsMapper,
                                       AreaCodeMapper areaCodeMapper,
                                       ForumPostMapper forumPostMapper,
                                       QuartzIntegrationService qartzIntegrationService){
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
        this.adminNewsMapper = adminNewsMapper;
        this.areaCodeMapper = areaCodeMapper;
        this.forumPostMapper = forumPostMapper;
        this.qartzIntegrationService = qartzIntegrationService;

    }


    @Override
    public PageWarper<MixRecommandDTO> getPagenationList(MixRecommandParam mixRecommandParam) {
        PageWarper<MixRecommandDTO> pageWarper = new PageWarper<>(mixedRecommendPoolMapper.queryByPageSize(mixRecommandParam));
        List<MixRecommandDTO> list = pageWarper.getList();
        list.stream().forEach( e->{
            if (StringUtils.isNotBlank( e.getAreaDetail())) {
                List<AreaCode> areaCodeList = areaCodeMapper.findListByCode(e.getAreaDetail().split(","));
                e.setAreaDetail(JSONObject.toJSONString(areaCodeList));
            }
        });
        pageWarper.setList(list);
        return pageWarper;
    }

    @Override
    public int cancelRecommendById(MixPoolParam mixPoolParam) {
        MixedRecommendPoolExample example = new MixedRecommendPoolExample();
        example.createCriteria().andIdEqualTo(mixPoolParam.getId()).andOriginEqualTo(mixPoolParam.getOrigin());
        int result = mixedRecommendPoolMapper.deleteByExample(example);
        //将新闻状态改为未推荐
        if (StringUtils.equals("2",mixPoolParam.getOrigin()) || StringUtils.equals("3",mixPoolParam.getOrigin())){
            News news = new News();
            news.setId(mixPoolParam.getId());
            news.setIsRecommend((byte) 0);
            adminNewsMapper.updateByPrimaryKeySelective(news);
        }else{
            ForumPost forumPost = new ForumPost();
            forumPost.setIsRecommend((byte) 0);
            forumPost.setId(mixPoolParam.getId());
            forumPostMapper.updateRecommendById(forumPost);
        }

        return result;
    }

    @Override
    public int updateMixRecommandWeight(MixPoolParam mixPoolParam, Integer weight) {
        MixedRecommendPoolExample example = new MixedRecommendPoolExample();
        example.createCriteria().andIdEqualTo(mixPoolParam.getId()).andOriginEqualTo(mixPoolParam.getOrigin());
        MixedRecommendPool pool = new MixedRecommendPool();
        pool.setWeight(weight);
        int result = mixedRecommendPoolMapper.updateByExampleSelective(pool, example);
        return result;
    }

    @Override
    public int updateMixRecommend(MixedRecommendPool mixedRecommendPool,MixedRecommendPool oldMixedRecommendPool) {
        int result = 0;
        if (Objects.nonNull(oldMixedRecommendPool)){
            oldMixedRecommendPool.setPublishTime(mixedRecommendPool.getPublishTime());
            String origin = oldMixedRecommendPool.getOrigin();
            //推荐库数据为本地新闻时
            String areaDetail = mixedRecommendPool.getAreaDetail();
            if (StringUtils.equals("2",origin)){
                if (StringUtils.isBlank(areaDetail)){
                    oldMixedRecommendPool.setOrigin("3");
                    oldMixedRecommendPool.setAreaDetail(null);
                }else{
                    oldMixedRecommendPool.setAreaDetail(mixedRecommendPool.getAreaDetail());
                }
             //推荐库数据为全国新闻时
            }else if (StringUtils.equals("3",origin)){
                if (StringUtils.isNotBlank(areaDetail)){
                    oldMixedRecommendPool.setOrigin("2");
                    oldMixedRecommendPool.setAreaDetail(mixedRecommendPool.getAreaDetail());
                }else{
                    oldMixedRecommendPool.setAreaDetail(null);
                }
             //推荐库数据为帖子时
            }else if (StringUtils.equals("1",origin)){
                oldMixedRecommendPool.setAreaDetail(StringUtils.isBlank(mixedRecommendPool.getAreaDetail()) ? null : mixedRecommendPool.getAreaDetail() );
            }
            oldMixedRecommendPool.setIssueTime(mixedRecommendPool.getIssueTime());
            oldMixedRecommendPool.setTitle(mixedRecommendPool.getTitle());
            result = mixedRecommendPoolMapper.updateByPrimaryKey(oldMixedRecommendPool);
        }
        return result;
    }

    @Override
    public int addTop(MixRecommendTopParam mixPoolParam) {
        int result = 0;
        if (StringUtils.isNotBlank(mixPoolParam.getNewsId())){
            String[] newsIds = mixPoolParam.getNewsId().split(",");
            for (String e: newsIds) {
                Long newsId = NumberUtils.toLong(e);
                MixedRecommendPool mixedRecommendPool = new MixedRecommendPool();
                mixedRecommendPool.setId(newsId);
                //将新闻设置成置顶
                mixedRecommendPool.setTop((byte)2);
                mixedRecommendPool.setTopEffectiveTime(mixPoolParam.getNewsEffectiveTime());
                mixedRecommendPool.setTopExpireTime(mixPoolParam.getNewsExpireTime());
                result += mixedRecommendPoolMapper.updateByPrimaryKeySelective(mixedRecommendPool);
            }
        }
        if (StringUtils.isNotBlank(mixPoolParam.getPostId())){
            String[] postIds = mixPoolParam.getPostId().split(",");
            for (String e: postIds) {
                Long postId = NumberUtils.toLong(e);
                MixedRecommendPool mixedRecommendPool = new MixedRecommendPool();
                mixedRecommendPool.setId(postId);
                //将帖子设置成置顶
                mixedRecommendPool.setTop((byte)2);
                mixedRecommendPool.setTopEffectiveTime(mixPoolParam.getPostEffectiveTime());
                mixedRecommendPool.setTopExpireTime(mixPoolParam.getPostExpireTime());
                result += mixedRecommendPoolMapper.updateByPrimaryKeySelective(mixedRecommendPool);
            }
        }

        return result;
    }

    @Override
    public int addNewstToRecommendPool(News news) {
        MixedRecommendPool mixedRecommendPool = mixedRecommendPoolMapper.selectByPrimaryKey(news.getId());
        int result = 0;
        if (Objects.isNull(mixedRecommendPool ) && news.getTop() == 1){
            mixedRecommendPool = new MixedRecommendPool();
            mixedRecommendPool.setOrigin(MixRecommendEnum.LOCALNEWS_ORIGIN.getOrigin());
            Date currentTime = new Date();
            mixedRecommendPool.setAddTime(currentTime);
            mixedRecommendPool.setModifyTime(currentTime);
            mixedRecommendPool.setWeight(-1);
            mixedRecommendPool.setTop((byte)1);
            mixedRecommendPool.setStatus((byte)1);
            mixedRecommendPool.setAuto((byte) 1);
            mixedRecommendPool.setTitle(news.getTitle());
            mixedRecommendPool.setAreaDetail(news.getAreaDetail());
            mixedRecommendPool.setIssueTime(news.getIssueTime());
            mixedRecommendPool.setAuto((byte) 0);
            mixedRecommendPool.setId(news.getId());
            mixedRecommendPool.setPublishTime(news.getPublishTime());
            mixedRecommendPool.setOptimizationNotice((byte) 0);
            mixedRecommendPool.setRecommendTime(new Date());
            result = mixedRecommendPoolMapper.insertSelective(mixedRecommendPool);
        }
        return result;
    }

    @Override
    public int doUpdateRecommandTimeById(Long id, Date recommendTime) {
        MixedRecommendPool oldPool = mixedRecommendPoolMapper.selectByPrimaryKey(id);
        ForumPost forumPost = forumPostMapper.selectByPrimaryKey(id);
        MixedRecommendPool record = new MixedRecommendPool();
        record.setId(id);
        record.setRecommendTime(recommendTime);
        int result = mixedRecommendPoolMapper.updateByPrimaryKeySelective(record);
        Date oldReCommendTime = oldPool.getRecommendTime();
        //判断修改的时间是否为帖子,并且帖子用户创建,并且原始的推荐时间大于当前时间(为推送时) 修改定时推送的定时任务
        boolean flag = StringUtils.equals(oldPool.getOrigin(), "1") &&
                Objects.nonNull(forumPost) &&
                Objects.isNull(forumPost.getCreator()) &&
                oldReCommendTime.compareTo(new Date()) == 1;
        if(flag){
            //调用quarz 生成定时任务
            OptimizationNoticeParam param = new OptimizationNoticeParam();
            param.setId(id);
            param.setStartTime(recommendTime);
            qartzIntegrationService.sendOptimizationNotice(param);
        }
        return result;
    }
}
