package com.bxm.localnews.admin.service.security;

import com.bxm.localnews.admin.dto.AdminRoleDTO;
import com.bxm.localnews.admin.param.RoleParam;
import com.bxm.localnews.admin.vo.AdminRole;
import com.bxm.newidea.component.vo.PageWarper;
import org.springframework.security.core.GrantedAuthority;

import java.util.Collection;
import java.util.List;

/**
 * @author zhaoyadong 2018/10/16 10:57
 * @desc
 */
public interface AdminRoleService {

    /**
     * 获取角色列表
     * @param roleParam
     * @return 分页结果
     */
    PageWarper<AdminRoleDTO> selectAll(RoleParam roleParam);

    /**
     * 根据唯一标识获取角色
     * @param roleCode
     * @return
     */
    AdminRole selectByRoleCode(String roleCode);

    /**
     * 添加角色
     * @param adminRole
     * @return
     */
    int insertSelective(AdminRole adminRole);

    /**
     * 更新角色
     * @param adminRole
     * @return
     */
    int updateByPrimaryKeySelective(AdminRole adminRole);

    /**
     * 删除角色
     * @param roleId
     * @return
     */
    int deleteByPrimaryKey(Integer roleId);

    /**
     * 获取角色信息
     * @param roleId
     * @return
     */
    AdminRole selectByPrimaryKey(Integer roleId);

    /**
     * 获取用户权限列表
     * @param id
     * @return
     */
    List<AdminRole> selectByUserId(Long id);

    /**
     * 获取用户的权限列表
     * @param userId
     * @return
     */
    Collection<? extends GrantedAuthority> getUserAuthorities(Long userId);
}
