package com.bxm.localnews.admin.service.security.impl;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.dto.UserInfoDTO;
import com.bxm.localnews.admin.param.UserInfoParam;
import com.bxm.localnews.admin.service.security.AdminUserBaseInfoService;
import com.bxm.localnews.admin.vo.User;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by Administrator on 2017/12/19.
 */

@Service
public class AdminUserBaseInfoServiceImpl extends BaseService implements AdminUserBaseInfoService {

    /**
     * 日志对象
     */
    private static final Logger LOG = LoggerFactory.getLogger(AdminUserBaseInfoServiceImpl.class);

    @Resource
    private UserMapper userBaseInfoMapper;

    /**
     * redis hash服务类
     */
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public PageWarper<UserInfoDTO> queryUserInfoDTO(UserInfoParam param) {
        return new PageWarper<>(this.userBaseInfoMapper.queryUserInfoList(param));
    }

    @Override
    public User selectByUserId(Long userId) {
        return this.userBaseInfoMapper.selectByUserId(userId);
    }

    @Override
    public boolean updateUserBlack(Map<String, Object> map) {
        return this.userBaseInfoMapper.updateUserBlack(map);
    }

    @Override
    public Boolean deleteUser(Long userId) {
        Long id = nextId();
        User user = selectByUserId(userId);

        if (null == user) {
            LOG.error("根据此userId:{}未查询到用户信息,删除用户失败");
            return false;
        }
        //删除缓存
        redisHashMapAdapter.remove(RedisConfig.USER_INFO, String.valueOf(userId));

        //TODO 三步删除用户数据库 一步删除redis缓存

        String weChat = user.getWeixin() == null ? null : user.getWeixin() + id;

        //更新用户为禁用,手机号、设备号置空,微信号特殊处理。
        userBaseInfoMapper.updateUser(userId, weChat);

        //更新vip邀请查看记录的微信号特殊处理
        userBaseInfoMapper.updateVipRecord(userId, weChat);
        if (StringUtils.isNotEmpty(user.getWeixin())) {
            userBaseInfoMapper.updateVipViewRecord(user.getWeixin(), weChat);
        }

        //删除设备号
        userBaseInfoMapper.deleteUserEquipment(user.getEquipment());

        //删除在授权登录认证表中信息
        return userBaseInfoMapper.deleteUser(userId) > 0;
    }

    @Override
    public List<UserInfoDTO> getVirtualUserList() {
        return this.userBaseInfoMapper.getVirtualUserList();
    }

//    @Override
//    public Boolean addVirtualUser(String nickname, String headImg) {
//        return this.userBaseInfoMapper.addVirtualUser(nickname, headImg) > 0;
//    }
}
