package com.bxm.localnews.common.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * redis 缓存的key值，格式为： {业务类型：模块：子模块:更下级模块} 业务类型： biz:业务 config:配置
 */
public class RedisConfig {

    /**
     * ====================================================================== activity 模块相关缓存键值 用户日常任务完成状态
     */
    public static KeyGenerator DAILY_TASK_COMPELE_STATUS = DefaultKeyGenerator.build("activity",
            "taskcompelestate");

    public static KeyGenerator SIGN_CONFIG_KEY = DefaultKeyGenerator.build("activity", "sign_config");

    /**
     * 用户分享图片缓存路径
     */
    public static KeyGenerator USER_SHARE_IMAGES = DefaultKeyGenerator.build("activity", "share",
            "userimg");

    /**
     * 用户分享图片缓存路径
     */
    public static KeyGenerator SIGN_CACHE_KEY = DefaultKeyGenerator.build("activity", "sign");

    /**
     * 用户签到总数缓存key
     */
    public static KeyGenerator SIGN_COUNT_KEY = DefaultKeyGenerator.build("activity", "sign");

    /**
     * 用户签到列表缓存key
     */
    public static KeyGenerator SIGN_LIST_KEY = DefaultKeyGenerator.build("activity", "signlist");

    /**
     * 用户当天完成任务获得奖励金币总数, 有效期:当天
     */
    public static KeyGenerator USER_MISSION_REWARD_SUM_PER_DAY = DefaultKeyGenerator.build("activity", "task",
            "sumreward");

    /**
     * 当日分享新闻次数 ,有效期:当天
     */
    public static KeyGenerator TASK_SHARE_NEWS_NUM = DefaultKeyGenerator.build("activity", "task",
            "sharenews");

    /**
     * 用户阅读新闻获得奖励的次数
     */
    public static KeyGenerator NEWS_READ = DefaultKeyGenerator.build("news", "readnews");

    /**
     * 用户阅读视频获得奖励的次数
     */
    public static KeyGenerator VIDEO_READ_NUM = DefaultKeyGenerator.build("activity", "task",
            "readvideo");

    /**
     * 用户每日发帖数量
     */
    public static KeyGenerator POST_FORUM = DefaultKeyGenerator.build("activity", "task", "postforum");

    /**
     * 用户vip卡编码生成记录
     */
    public static KeyGenerator USER_VIP_NUM_RECORD = DefaultKeyGenerator.build("activity", "user_vip",
            "num");

    /**
     * 用户已激活vip信息(昵称)
     */
    public static KeyGenerator USER_VIP_RANK = DefaultKeyGenerator.build("activity", "user_vip",
            "rank");

    /**
     * 用户已激活vip信息(头像)
     */
    public static KeyGenerator USER_VIP_RANK_IMG = DefaultKeyGenerator.build("activity", "user_vip",
            "rank_img");

    /**
     * 用户领取vip时的过期时间戳 有效期：半个小时
     */
    public static KeyGenerator USER_RECEIVE_VIP_TIME = DefaultKeyGenerator.build("activity",
            "vip_valid_time");

    /**
     * 用户显示浮层24小时后的时间戳 有效期：24小时
     */
    public static KeyGenerator USER_LAYER_EXPIRE_TIME = DefaultKeyGenerator.build("activity",
            "vip_layer_time");

    /**
     * 用户是否显示浮层
     */
    public static KeyGenerator USER_SHOW_LAYER = DefaultKeyGenerator.build("activity",
            "user_show_layer");

    /**
     * ====================================================================== user 模块相关缓存键值 用户信息
     */
    public static KeyGenerator USER_INFO = DefaultKeyGenerator.build("user", "cache", "userInfo");

    /**
     * 用户等级配置
     */
    public static KeyGenerator USER_LEVEL_CONFIG = DefaultKeyGenerator.build("user", "user", "level");

    /**
     * 微信同步时效
     */
    public static KeyGenerator WEIXIN_SYS_LIMIT = DefaultKeyGenerator.build("user", "sync",
            "weixin_sys_limit");

    /**
     * ====================================================================== thirdparty 模块相关缓存键值 短链接key
     */
    public static KeyGenerator SHORT_URL = DefaultKeyGenerator.build("thirdparty", "cache",
            "short_url");

    /**
     * 机器扫描短链接
     */
    public static KeyGenerator MACHINE_SHORT_URL_KEY = DefaultKeyGenerator.build("thirdparty", "machine");

    /**
     * 机器扫描总次数
     */
    public static KeyGenerator MACHINE_SCAN_COUNT = DefaultKeyGenerator.build("thirdparty",
            "machineScanCount");

    /**
     * 积分商城列表
     */
    public static KeyGenerator POINTS_MALL_KEY = DefaultKeyGenerator.build("thirdparty", "pointsMall");

    /**
     * 天气（半个小时刷新一次）
     */
    public static KeyGenerator THIRDPARTY_WEATHER = DefaultKeyGenerator.build("thirdparty", "weather");

    /**
     * 天气（未来7天的天气预报信息）
     */
    public static KeyGenerator THIRDPARTY_FUTURE_WEATHER = DefaultKeyGenerator.build("thirdparty", "future_weather");

    /**
     * 万年历（当天的黄历三天时间过期）
     */
    public static KeyGenerator THIRDPARTY_CALENDAR = DefaultKeyGenerator.build("thirdparty", "calendar");

    /**
     * 工具类列表(7天过期)
     */
    public static KeyGenerator THIRDPARTY_AREACODE_TOOLS = DefaultKeyGenerator.build("thirdparty",
            "areacode_tools");

    /**
     * 广告类列表
     */
    public static KeyGenerator THIRDPARTY_TYPE_ADVERT = DefaultKeyGenerator.build("thirdparty", "advert");

    /**
     * 广告展示方式
     */
    public static KeyGenerator THIRDPARTY_SHOW_TYPE_ADVERT = DefaultKeyGenerator.build("thirdparty", "advert");

    /**
     * 蓝领招聘
     */
    public static KeyGenerator THIRDPARTY_RECRUIT = DefaultKeyGenerator.build("thirdparty", "recruit");

    /**
     * 吃喝玩乐
     */
    public static KeyGenerator THIRDPARTY_ENJOY_EAT = DefaultKeyGenerator.build("thirdparty", "enjoy_eat");

    /**
     * 用户消息通知红点缓存
     */
    public static KeyGenerator MSG_RED_POINT = DefaultKeyGenerator.build("message", "red_point");

    /**
     * channel 所有渠道版本信息
     */
    public static KeyGenerator BASE_APPVERSION_CHANNEL = DefaultKeyGenerator.build("base",
            "appversion_channel");

    /**
     * ip 存放美国ip的提包状态（设置为true）
     */
    public static KeyGenerator BASE_IP = DefaultKeyGenerator.build("base", "ip");

    /**
     * 活动邀请人数排行榜缓存
     */
    public static KeyGenerator PRIVILEGE_INVITENUM = DefaultKeyGenerator.build("activity", "privilege_invitenum");

    /**
     * 活动列表缓存
     */
    public static KeyGenerator PRIVILEGE_lIST = DefaultKeyGenerator.build("activity", "privilege_list");

    /**
     * channel 所有渠道信息
     */
    public static KeyGenerator BASE_CHANNEL = DefaultKeyGenerator.build("base", "channel");

    /**
     * 热门城市信息
     */
    public static KeyGenerator HOT_LOCATION = DefaultKeyGenerator.build("base", "location", "hot");

    /**
     * 定位城市信息
     */
    public static KeyGenerator OPENED_LOCATION = DefaultKeyGenerator.build("base", "location",
            "opened");


    /**
     * 客服信息
     */
    public static KeyGenerator CUSTOMER_SERVICE_INFO = DefaultKeyGenerator.build("base", "location", "customer_service_info");


    /**
     * 区域信息
     */
    public static KeyGenerator AREA_INFO = DefaultKeyGenerator.build("base", "area", "info");

    /**
     * 地区编码和名称的映射缓存
     */
    public static KeyGenerator AREA_INFO_MAP = DefaultKeyGenerator.build("base", "area", "map");

    /**
     * 微信分享话术对应的自增值
     */
    public static KeyGenerator WEIXIN_LOCATION_RELATION = DefaultKeyGenerator.build("base", "location_relation", "weixin");

    /**
     * 微信朋友圈分享话术对应的自增值
     */
    public static KeyGenerator WEIXIN_FRIEND_LOCATION_RELATION = DefaultKeyGenerator.build("base", "location_relation", "wx_friend");

    /**
     * 微信小程序分享话术对应的自增值
     */
    public static KeyGenerator WEIXIN_APPLET_LOCATION_RELATION = DefaultKeyGenerator.build("base", "location_relation", "weixin_applet");

    /**
     * 微信朋友圈分享话术对应的自增值
     */
    public static KeyGenerator WEIXIN_APPLET_FRIEND_LOCATION_RELATION = DefaultKeyGenerator.build("base", "location_relation", "wx_friend_applet");

    /**
     * 微信相关key的存放
     */
    public static KeyGenerator WEIXIN_KEY = DefaultKeyGenerator.build("thirdparty", "weixin");


    /**
     * 微信formId缓存 过期时间：24小时
     */
    public static KeyGenerator WEIXIN_FORMID = DefaultKeyGenerator.build("thirdparty", "weixin_formId");

    /**
     * ====================================================================== payment 模块相关缓存信息
     */

    /**
     * 微信订单状态缓存 过期时间：24小时
     */
    public static KeyGenerator WEIXIN_ORDER_STATUS = DefaultKeyGenerator.build("payment", "weixin_order");

    public static KeyGenerator USER_WITHDRAW = DefaultKeyGenerator.build("payment", "user_withdraw");


}
