package com.bxm.localnews.base.domain;

import com.bxm.localnews.common.entity.DomainInfo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;


@Mapper
public interface DomainExtendMapper {

    /**
     * 根据场景获取可用的域名信息列表
     * @param scene required 场景值
     * @param viewScene 落地页场景
     * @param appId option 某些场景是在微信环境下的，所以选用appid对应的域名
     * @return 域名信息列表
     */
    List<DomainInfo> selectAvailableDomainByScene(@Param("scene") byte scene, @Param("viewScene") Byte viewScene, @Param("appId") String appId);
}
