package com.bxm.localnews.base.domain;

import com.bxm.localnews.common.vo.Location;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface LocationMapper {

    Location selectByPrimaryKey(Long id);

    /**
     * 查询城市信息
     * @param code 地区编码
     * @param lastCodeQuery 是否查询最新的编码
     * @return
     */
    Location selectByCode(@Param("code") String code, @Param("lastCodeQuery") boolean lastCodeQuery);

    Location selectActivateLocation();


    List<Location> selectByModel(Location record);

    List<String> selectLocationWithCommunity();

    /**
     * 根据地区code且客服小助手为开通,获取客服信息
     *
     * @param code 地区code
     * @return 查询结果
     */
    Location selectCustomerServiceByCode(String code);

    String selectCodeByName(String city);

    void updateByCodeSelective(Location record);

}