package com.bxm.localnews.common.dto;

import com.bxm.localnews.common.vo.AppVersion;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "APP版本信息")
public class AppVersionMeta {

    @ApiModelProperty(value = "当前最新版本")
    private AppVersion version;

    @ApiModelProperty(value = "提包开关，1：隐藏，2：开放")
    private String switchType;

    @ApiModelProperty(value = "首页版权信息开关 0：关 1：开")
    private String companyType;

    @ApiModelProperty(value = "首页版权信息内容")
    private String companyName;

    @ApiModelProperty("最新版本的安装文件下载路径")
    private String lastVersionUrl;

    public AppVersionMeta() {
    }

    public String getLastVersionUrl() {
        return this.lastVersionUrl;
    }

    public void setLastVersionUrl(String lastVersionUrl) {
        this.lastVersionUrl = lastVersionUrl;
    }

    public AppVersion getVersion() {
        return this.version;
    }

    public void setVersion(AppVersion version) {
        this.version = version;
    }

    public String getSwitchType() {
        return this.switchType;
    }

    public void setSwitchType(String switchType) {
        this.switchType = switchType;
    }

    public String getCompanyType() {
        return this.companyType;
    }

    public void setCompanyType(String companyType) {
        this.companyType = companyType;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

}
