package com.bxm.localnews.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "地区返回包装类")
@Data
public class LocationDTO {

    @ApiModelProperty("地区编码")
    private String code;

    @ApiModelProperty("地区简称")
    private String name;

    @ApiModelProperty("是否热门城市（1表示true）(2表示附近的城市)")
    private Byte hot;

    @ApiModelProperty("城市级别（2：市、3：县（区））")
    private Byte level;

    @ApiModelProperty("首字母")
    private String pinyin;

    @ApiModelProperty("该地区是否开启vip")
    private Byte enableVip;

    @ApiModelProperty("如果是附近的城市，则表示当前定位和城市的距离")
    private Double distance;

    @ApiModelProperty(value = "地区最新的行政编码", hidden = true)
    private String lastCode;

    @ApiModelProperty(value = "地区排序", hidden = true)
    private Integer order;

    @ApiModelProperty(value = "纬度", hidden = true)
    private Double lat;

    @ApiModelProperty(value = "经度", hidden = true)
    private Double lng;
}
