package com.bxm.localnews.common.entity;

import lombok.Data;

/**
 * @author gonzo
 * @date 2020-07-30 18:07
 **/
@Data
public class DomainInfo {
    /**
     * 域名表主键
     */
    private Long id;

    /**
     * 域名（不带协议）
     */
    private String domain;

    /**
     * 协议 http:// or https://
     */
    private String protocol;

    /**
     * 投放场景 0: 站内H5 1：站内淘宝授权 2: 短链 3: 站外分享域名 4: 站外分享落地页域名  5: 站外微信用户授权中间页 6: 站外微信支付中间页
     */
    private Byte scene;

    /**
     * 如果域名场景是落地页域名 则该字段标识落地页场景 0: 非落地页域名 1: 站外内容落地页 2: 站外推广落地页 3: 站外活动落地页
     */
    private Byte viewScene;
}
