package com.bxm.localnews.common.param;

import com.bxm.localnews.common.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Objects;

@Data
@ApiModel("设备上报信息")
public class EquipmentParam extends BasicParam {

    @ApiModelProperty("android:表示唯一值，不同手机返回不同（ IOS_DEVICE_ID/MAC 等 ），本文档中主要用于表示设备唯一码。重置系统不会重置，需要申请权限后获取。")
    private String IMEI;

    @ApiModelProperty("android：安卓系统初始化时创建一次，重置系统会被重置")
    private String androidId;

    @ApiModelProperty("android：每次即生成的uuid")
    private String androidUuid;

    @ApiModelProperty("ios：中的 广告追踪 ID ， 用户可进行重置或阻止追踪 （返回 16 个 0 ）")
    private String idfa;

    @ApiModelProperty("ios：本文档中特指 iOS 设备号，由 App 创建后上传，可保证同一设备同一 App 重复安装仍保持一致")
    private String iosId;

    @ApiModelProperty("是否开启消息通知 否:false")
    private boolean enableNotification;

    @ApiModelProperty("手机型号")
    private String phoneModel;

    @ApiModelProperty("操作系统版本")
    private String operatingSystem;

    @ApiModelProperty("用户设备应用信息[包含包名和应用名]仅支持安卓")
    private String appInfoParamList;

    @ApiModelProperty("是否开启定位 0：未开启  1：已开启")
    private Integer enableLocation;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EquipmentParam that = (EquipmentParam) o;
        return Objects.equals(IMEI, that.IMEI) &&
                Objects.equals(androidId, that.androidId) &&
                Objects.equals(androidUuid, that.androidUuid) &&
                Objects.equals(idfa, that.idfa) &&
                Objects.equals(iosId, that.iosId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), IMEI, androidId, androidUuid, idfa, iosId);
    }
}
