package com.bxm.localnews.common.param;

import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.common.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 *
 * @author gonzo
 * @date 2020-07-30 17:01
 **/
@Data
@ApiModel("根据场景获取可用域名信息参数")
public class GetAvailableDomainInfoParam extends BasicParam {

    /**
     * 场景值 {@link DomainScene}
     */
    @ApiModelProperty("场景类型 INNER_H5: 站内h5 AUTH_TAOBAO: 淘宝授权 SHORT: 短链 OUTSIDE_SHARE: 站外分享 " +
            "WECHAT_AUTH: 站外微信用户授权中间页 WECHAT_PAY: 站外微信支付中间页")
    private String scene;

    /**
     * 落地页场景值 {@link DomainScene.DomainViewScene}
     */
    @ApiModelProperty("落地页场景值 如果选择的是落地页场景，则需要指定具体的落地页类型 CONTENT_VIEW: 站外内容落地页 PROMOTION_VIEW: 站外推广落地页 ACTIVITY_VIEW: 站外活动落地页")
    private String viewScene;

    @ApiModelProperty(value = "appId 某些场景如微信环境的授权，是需要appId和域名相互绑定的 所以需要传入app id来获取对应的域名", hidden = true)
    private String appId;

}