package com.bxm.localnews.base.service;

import com.bxm.localnews.common.dto.AreaDivisionDTO;
import com.bxm.localnews.common.dto.CustomerServiceDTO;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.common.dto.LocationMeta;
import com.bxm.localnews.common.param.ListAreaLocationParam;
import com.bxm.localnews.common.vo.AreaCode;
import com.bxm.localnews.common.vo.BasicParam;

import java.util.List;

public interface LocationService {

    /**
     * 用途：获取对应地区的编码
     * @param name     地区
     * @param province 省市
     * @return 地区的编码
     */
    AreaCode selectByAreaName(String name, String province);

    /**
     * 用途：获取热门城市列表以及已开通城市列表
     * @return
     */
    LocationMeta listLocation(ListAreaLocationParam param);

    /**
     * 用途：根据父级编号获得省市区街道地址
     * @param parentCode
     * @return
     */
    List<AreaDivisionDTO> listAreaDivisionDTO(String parentCode);

    /**
     * 根据客户端传来的城市编码获得区县信息
     * 客户端传来的编号是通过高德api得到的，只有6位，需要对其进行补位，以12位的编码去查询
     * 如果查询不到，则去查找他的上一级
     * example：
     * 1."淳安县"：由于是县，直接在已开通城市中可以找到
     * 2."西湖区"：由于是区，需要在上一级(杭州)去查询
     * @see #getInternalLocationByGeocode#(String, BasicParam, boolean)
     * @param code
     * @return
     */
    LocationDetailDTO getInternalLocationByGeocode(String code, BasicParam basicParam);

    /**
     * 根据客户端传来的城市编码获得区县信息
     * 客户端传来的编号是通过高德api得到的，只有6位，需要对其进行补位，以12位的编码去查询
     * 如果查询不到，则去查找他的上一级
     * example：
     * 1."淳安县"：由于是县，直接在已开通城市中可以找到
     * 2."西湖区"：由于是区，需要在上一级(杭州)去查询
     * @param code
     * @param queryParent 是否当查询不到时查询上一级 3.3.1新增参数，如果是客户端调用则不继续查询，如果是内部调用为了兼容，继续查询
     * @param queryDefault 当根据code查询不到时，是否返回默认的城市 3.3.1版本新增，查询不到就不返回了，但是需要兼容老版本
     * @param lastCodeQuery 标识code是否用来查询最新的code 如果是前端的请求，则调用高德的api返回的是最新编码 需要通过lastCode查询
     * @return
     */
    LocationDetailDTO getInternalLocationByGeocode(String code, BasicParam basicParam, boolean queryParent, boolean queryDefault, boolean lastCodeQuery);

    /**
     * 根据区域编码获取客服信息
     * @param code 区域编码
     * @return 客服信息-先从缓存中得 要是从缓存中未获取到则从数据库中
     */
    CustomerServiceDTO getCustomerServiceInfo(String code);

    /**
     * 得到所有开通社区内容的地区编号
     * @return
     */
    List<String> listAllLocationWithCommunity();

}
