package com.bxm.localnews.base.service.domain;

import com.bxm.localnews.base.service.domain.joins.DefaultSceneBaseUrlJointer;
import com.bxm.localnews.base.service.domain.joins.SceneBaseUrlJointer;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.common.dto.JointerContext;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 场景base url 拼接器
 * @author gonzo
 * @date 2020-07-30 18:59
 **/
@Slf4j
@Component
public class SceneBaseUrlJoiner {

    private final Map<DomainScene, SceneBaseUrlJointer> JOINTER_MAP = Maps.newHashMap();

    private final DefaultSceneBaseUrlJointer defaultJointer;


    public SceneBaseUrlJoiner(List<SceneBaseUrlJointer> jointerList, DefaultSceneBaseUrlJointer defaultJointer) {
        jointerList.forEach(p -> {
            if (Objects.nonNull(p.support())) {
                JOINTER_MAP.put(p.support(), p);
            }
        });

        this.defaultJointer = defaultJointer;
    }


    /**
     * 根据场景拼接url
     * @param scene 场景
     * @param viewScene optional 具体落地页类型 如果当前场景是拼接分享，则需要制定具体落地页类型进行拼接
     * @param domainWithProtocol 拼接前的url
     * @return 拼接后的url
     */
    public String joinByScene(DomainScene scene, DomainScene.DomainViewScene viewScene, String domainWithProtocol) {

        if (Objects.isNull(scene) || StringUtils.isBlank(domainWithProtocol)) {
            return "";
        }

        JointerContext context = new JointerContext();
        context.setUrl(domainWithProtocol);
        context.setScene(scene);
        context.setDomainViewScene(viewScene);

        SceneBaseUrlJointer jointer = JOINTER_MAP.get(scene);
        if (Objects.isNull(jointer)) {
            // 如果根据类型没有获取到可用的拼接器 则选择默认的
            return defaultJointer.join(context);
        }
        return jointer.join(context);
    }

}
