package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.domain.ChannelMapper;
import com.bxm.localnews.base.service.ChannelService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.constant.AppConst;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.ChannelDTO;
import com.bxm.localnews.common.vo.Channel;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/12/23.
 */

@Service

public class ChannelServiceImpl implements ChannelService {

    private final static Logger logger = LoggerFactory.getLogger(ChannelServiceImpl.class);

    private ChannelMapper channelMapper;

    private BizConfigProperties bizConfigProperties;

    private RedisStringAdapter redisStringAdapter;

    @Autowired
    public ChannelServiceImpl(ChannelMapper channelMapper, BizConfigProperties bizConfigProperties,
                              RedisStringAdapter redisStringAdapter) {
        this.channelMapper = channelMapper;
        this.bizConfigProperties = bizConfigProperties;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public List<ChannelDTO> listChannel(Map<String, Object> searchMap, int current, int pageSize) {
        PageHelper.startPage(current, pageSize);
        List<ChannelDTO> list = this.channelMapper.selectChannelList(searchMap);
        String channelUrl = bizConfigProperties.getChannelUrl();

        for (ChannelDTO channelDTO : list) {
            channelDTO.setGeneralizeUrl(channelUrl + channelDTO.getCode());
        }

        return list;
    }

    @Override
    public Channel getChannelByCode(String code) {
        Channel channel = new Channel();
        List<Channel> channelList = getChannelList();
        for (Channel ch : channelList) {
            if (ch.getCode().equals(code)) {
                channel = ch;
                break;
            }
        }

        return channel;
    }

    /**
     * 获取所有的渠道列表
     * @return
     */
    private List<Channel> getChannelList() {
        TypeReference<List<Channel>> typeReference = new TypeReference<List<Channel>>() {
        };
        List<Channel> channelList = this.redisStringAdapter.get(this.getChannelListKey(), typeReference);
        if (CollectionUtils.isEmpty(channelList)) {
            channelList = this.channelMapper.getAllChannel();
            this.redisStringAdapter.set(this.getChannelListKey(), channelList);
        }

        return channelList;
    }

    /**
     * 获取渠道版本列表的key
     * @return
     */
    private KeyGenerator getChannelListKey() {
        return RedisConfig.BASE_CHANNEL.copy().appendKey("list");
    }

    /**
     * 暂时没用
     * @param userId
     * @param chnl
     * @param inviterCode
     */
    @Override
    public void pushChannelInviterInfo(Long userId, String chnl, Long inviterCode) {
        try {
            logger.info("上传邀请关系，渠道码=" + chnl + ",用户ID=" + userId + ",邀请码=" + inviterCode);
            if (StringUtils.isBlank(chnl) || null == inviterCode) {
                return;
            }
            Map<String, Object> searchMap = new HashMap<>();
            searchMap.put("code", chnl);
            searchMap.put("state", AppConst.STATE_USE);
            Channel channel = this.channelMapper.findSelective(searchMap);
//            if (null != channel) {
//                if (YIN_HE_LIAN_MENG.equals(channel.getCode())) {
////                    mqSenderService.sendRegMsg(userId,inviterCode);
//                }
//            }
        } catch (Exception e) {
            logger.error("上传邀请关系失败，渠道码=" + chnl + ",用户ID=" + userId + ",邀请码=" + inviterCode);
        }
    }
}
