/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.config;

import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.interceptor.RequestSignInterceptor;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.handler.MappedInterceptor;

@Configuration
public class WebConfiguration
implements WebMvcConfigurer {
    @Resource
    private BizConfigProperties bizConfigProperties;
    @Resource
    private RequestSignInterceptor requestSignInterceptor;

    @Bean
    public CorsFilter corsFilter() {
        String[] origins = StringUtils.split((String)this.bizConfigProperties.getAllowOrigins(), (String)",");
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        for (String origin : origins) {
            corsConfiguration.addAllowedOrigin(origin);
        }
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", corsConfiguration);
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Bean
    public MappedInterceptor mappedInterceptor() {
        String[] mappingUrls = new String[]{"/api/**"};
        String[] excludeMapping = new String[]{"/api/admin/**", "/api/app/**", "/api/news/detailUrl.json", "/api/news/syDetail.json", "/api/news/detail/recommend.json", "/api/news/readShare/gold.json", "/api/news/read/back.json", "/api/news/video/regain.json", "/api/apprenticeship/topRanking", "/api/user/apprentice", "/api/sms/vcode", "/api/sms/check", "/api/user/H5/toRegister", "/api/mission/listMission", "/api/apprenticeship/getApprenticeInfo", "/api/advert/click.json", "/api/advert/show.json", "/api/app/publish", "/api/user/getPayToken", "/api/withdraw/apply", "/api/redpacket/invite/**", "/api/redpacket/invite/**", "/api/withdraw/**", "/api/download/andriod/**", "/api/public/**", "/api/h5/**", "/m/**", "/api/amount/balance", "/api/amount/deduct/balance", "/api/amount/confirm/deduct/balance", "/api/user/getUserInfo", "/api/sign/listSignRecord", "/api/sign/dailySign", "/api/area/**"};
        return new MappedInterceptor(mappingUrls, excludeMapping, (HandlerInterceptor)this.requestSignInterceptor);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.mappedInterceptor());
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        FastJsonHttpMessageConverter converter = new FastJsonHttpMessageConverter();
        FastJsonConfig config = new FastJsonConfig();
        config.setDateFormat("yyyy-MM-dd HH:mm:ss");
        config.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteDateUseDateFormat});
        ParserConfig.getGlobalInstance().setAutoTypeSupport(true);
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(MediaType.APPLICATION_JSON_UTF8);
        converter.setSupportedMediaTypes(mediaTypes);
        converter.setFastJsonConfig(config);
        converters.add((HttpMessageConverter<?>)converter);
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET", "HEAD", "POST", "PUT", "DELETE", "OPTIONS"}).allowCredentials(false).maxAge(3600L);
    }
}

