/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.interceptor;

import com.bxm.newidea.component.tools.DateUtils;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
@Component
public class PerformanceInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger((String)"SQL");
    private static final long SLOW_SQL_EXEC_TIMING = 100L;

    public Object intercept(Invocation invocation) throws Throwable {
        long end;
        long timing;
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        Object parameterObject = null;
        if (invocation.getArgs().length > 1) {
            parameterObject = invocation.getArgs()[1];
        }
        String statementId = mappedStatement.getId();
        BoundSql boundSql = mappedStatement.getBoundSql(parameterObject);
        Configuration configuration = mappedStatement.getConfiguration();
        String sql = this.getSql(boundSql, parameterObject, configuration);
        long start = System.currentTimeMillis();
        Object result = invocation.proceed();
        if (sql != null && (timing = (end = System.currentTimeMillis()) - start) > 100L) {
            logger.info("statementId:{},use:{}ms,sql:{}", new Object[]{statementId, timing, sql});
        }
        return result;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    private String getSql(BoundSql boundSql, Object parameterObject, Configuration configuration) {
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        List parameterMappings = boundSql.getParameterMappings();
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        if (parameterMappings != null) {
            for (int i = 0; i < parameterMappings.size(); ++i) {
                Object value;
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                if (boundSql.hasAdditionalParameter(propertyName)) {
                    value = boundSql.getAdditionalParameter(propertyName);
                } else if (parameterObject == null) {
                    value = null;
                } else if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                    value = parameterObject;
                } else {
                    MetaObject metaObject = configuration.newMetaObject(parameterObject);
                    value = metaObject.getValue(propertyName);
                }
                sql = this.replacePlaceholder(sql, value);
            }
        }
        return sql;
    }

    private String replacePlaceholder(String sql, Object propertyValue) {
        try {
            String result = propertyValue != null ? (propertyValue instanceof String ? "'" + propertyValue + "'" : (propertyValue instanceof Date ? "'" + DateUtils.formatDateTime((Date)((Date)propertyValue)) + "'" : propertyValue.toString())) : "null";
            return sql.replaceFirst("\\?", result);
        }
        catch (Exception e) {
            logger.error("replacePlaceholder: {} {}", (Object)sql, propertyValue);
            return null;
        }
    }
}

