/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.interceptor;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.annotation.TouTiaoAuth;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.HttpParamUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.service.UserService;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.util.WebUtils;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class RequestSignInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log;
    private static final List<String> EXCLUDE_LIST;
    private static final List<String> NOT_NULL_PARAMS;
    @Resource
    private BizConfigProperties bizConfigProperties;
    @Resource
    private UserService userService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        TouTiaoAuth tigerCardAuth;
        String reCalSign;
        StringBuilder reqInfo = new StringBuilder();
        String url = request.getRequestURI();
        String ip = WebUtils.getIpAddr((HttpServletRequest)request);
        String userId = request.getParameter("userId");
        reqInfo.append("request url=").append(url);
        reqInfo.append(",IP=").append(ip);
        reqInfo.append(",userId=").append(userId);
        log.debug("request info:[{}]", (Object)reqInfo.toString());
        String requestApiSign = HttpParamUtil.getSignStr((Map)request.getParameterMap(), (String)"|", (List)EXCLUDE_LIST);
        log.debug("requestApiSign:[{}]", (Object)requestApiSign);
        if (!this.bizConfigProperties.getEnableRequestSign().booleanValue()) {
            return true;
        }
        for (String paramName : NOT_NULL_PARAMS) {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter(paramName))) continue;
            Json responseJson = Json.build((int)RespCode.BAD_REQUEST, (String)"miss base params");
            response.getWriter().print(JSON.toJSONString((Object)responseJson));
            log.error("miss base params:[{}]", (Object)paramName);
            log.error("request info:[{}]", (Object)reqInfo.toString());
            log.error("requestApiSign:[{}]", (Object)requestApiSign);
            return false;
        }
        String apiSign = request.getParameter("apiSign");
        if (StringUtils.notEquals((CharSequence)apiSign, (CharSequence)(reCalSign = MD5Util.hgmd5((String)(requestApiSign + this.bizConfigProperties.getApiSignKey()))))) {
            Json responseJson = Json.build((int)RespCode.BAD_REQUEST, (String)"api sign error");
            response.getWriter().print(JSON.toJSONString((Object)responseJson));
            log.error("request sign:" + apiSign);
            log.error("actual sign:" + reCalSign);
            log.error("apiSign error:" + request.getRemoteAddr() + "," + request.getRequestURL() + "," + request.getHeader("User-Agent"));
            log.error("request sign param\uff1a" + requestApiSign);
            return false;
        }
        if (handler.getClass().isAssignableFrom(HandlerMethod.class) && (tigerCardAuth = (TouTiaoAuth)((HandlerMethod)handler).getMethodAnnotation(TouTiaoAuth.class)) != null) {
            UserInfoDTO dto;
            Long uid = null;
            try {
                uid = Long.parseLong(request.getParameter("userId"));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            String token = request.getParameter("token");
            if (uid != null && !StringUtils.isEmpty((CharSequence)token) && null != (dto = this.userService.getUserFromRedisDB(uid.longValue()))) {
                if (!token.equals(dto.getToken())) {
                    Json responseJson = Json.build((int)1000, (String)"\u8bf7\u91cd\u65b0\u767b\u5f55");
                    response.getWriter().print(JSON.toJSONString((Object)responseJson));
                    log.error("token time out:" + request.getRemoteAddr() + "," + request.getRequestURL() + "," + request.getHeader("User-Agent"));
                    return false;
                }
                return true;
            }
            Json responseJson = Json.build((int)RespCode.BAD_REQUEST, (String)"token error");
            response.getWriter().print(JSON.toJSONString((Object)responseJson));
            log.error("token error:" + request.getRemoteAddr() + "," + request.getRequestURL() + "," + request.getHeader("User-Agent"));
            return false;
        }
        return true;
    }

    static {
        Field[] fields;
        log = LoggerFactory.getLogger(RequestSignInterceptor.class);
        EXCLUDE_LIST = Collections.singletonList("apiSign");
        NOT_NULL_PARAMS = Lists.newArrayList();
        for (Field field : fields = BasicParam.class.getDeclaredFields()) {
            NOT_NULL_PARAMS.add(field.getName());
        }
    }
}

