/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.common.constant;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public enum DomainScene {
    INNER_H5(0, "\u7ad9\u5185h5"),
    AUTH_TAOBAO(1, "\u6dd8\u5b9d\u6388\u6743"),
    SHORT(2, "\u77ed\u94fe"),
    OUTSIDE_SHARE(3, "\u7ad9\u5916\u5206\u4eab"),
    OUTSIDE_SHARE_VIEW(4, "\u7ad9\u5916\u843d\u5730\u9875"),
    WECHAT_AUTH(5, "\u7ad9\u5916\u5fae\u4fe1\u7528\u6237\u6388\u6743\u4e2d\u95f4\u9875"),
    WECHAT_PAY(6, "\u7ad9\u5916\u5fae\u4fe1\u652f\u4ed8\u4e2d\u95f4\u9875"),
    SERVER_HOST(7, "\u670d\u52a1\u5668\u57df\u540d");

    private byte scene;
    private String desc;

    private DomainScene(byte scene, String desc) {
        this.scene = scene;
        this.desc = desc;
    }

    public byte getScene() {
        return this.scene;
    }

    public String getDesc() {
        return this.desc;
    }

    public static Optional<DomainScene> forName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return Optional.empty();
        }
        return Arrays.stream(DomainScene.values()).filter(p -> Objects.equals(p.name(), name)).findAny();
    }

    public static enum DomainViewScene {
        CONTENT_VIEW(1, "\u7ad9\u5916\u5185\u5bb9\u843d\u5730\u9875"),
        PROMOTION_VIEW(2, "\u7ad9\u5916\u63a8\u5e7f\u843d\u5730\u9875"),
        ACTIVITY_VIEW(3, "\u7ad9\u5916\u6d3b\u52a8\u843d\u5730\u9875");

        private byte scene;
        private String desc;

        private DomainViewScene(byte scene, String desc) {
            this.scene = scene;
            this.desc = desc;
        }

        public byte getScene() {
            return this.scene;
        }

        public String getDesc() {
            return this.desc;
        }

        public static Optional<DomainViewScene> forName(String name) {
            if (StringUtils.isBlank((CharSequence)name)) {
                return Optional.empty();
            }
            return Arrays.stream(DomainViewScene.values()).filter(p -> Objects.equals(p.name(), name)).findAny();
        }
    }
}

