package com.bxm.localnews.common.constant;

import com.bxm.newidea.component.tools.BitOperatorUtil;

/**
 * 个人资料完善情况
 * 不解释了，优秀的代码看命名就知道意思
 */
public enum InfoCombineStateEnum {

    HEAD_IMG_COMPLETE(0),

    NICKNAME_COMPLETE(1),

    SEX_COMPLETE(2),

    BIRTHDAY_COMPLETE(3),

    HOMETOWN_COMPLETE(4),

    RELATION_SHIP_COMPLETE(5),

    JOB_COMPLETE(6),

    PERSONAL_PROFILE_COMPLETE(7),

    USER_TAG_COMPLETE(8),

    PHONE_COMPLETE(9),

    WECHAT_COMPLETE(10);

    public int index;

    public int getIndex() {
        return index;
    }

    private InfoCombineStateEnum(int index) {
        this.index = index;
    }



    public static InfoCombineStateEnum getByIndex(Integer index) {
        InfoCombineStateEnum[] var1 = values();
        int var2 = var1.length;

        for (int var3 = 0; var3 < var2; ++var3) {
            InfoCombineStateEnum authCodeEnum = var1[var3];
            if (index == authCodeEnum.index) {
                return authCodeEnum;
            }
        }

        return null;
    }

    /**
     * 得到资料完善度的数量
     * 完善一项获得一分
     *
     * @param infoCompleteStatus
     * @return
     */
    public static int getInfoCompleteStatus(Long infoCompleteStatus) {
        String s = Long.toBinaryString(infoCompleteStatus);
        int completeCount = 0;
        for (int i = 0; i < s.length(); i++) {
            char c = s.charAt(i);
            if ('1' == c) {
                completeCount++;
            }
        }
        return completeCount;
    }

    /**
     * 得到资料未完善度的数量
     *
     * @param infoCompleteStatus
     * @return
     */
    public static int getInfoUnCompleteStatus(Long infoCompleteStatus) {
        int length = InfoCombineStateEnum.values().length;
        int completeStatus = getInfoCompleteStatus(infoCompleteStatus);
        return length - completeStatus;
    }

    /**
     * 生成资料完善百分比(自定义规则)
     * 部分选项获得两分
     * @param infoCompleteStatus
     * @return
     */
    public static int getCustomInfoCompleteStatus(Long infoCompleteStatus){
        int infoCompleteValue = 0;
        if (BitOperatorUtil.getBitAsBoolean(infoCompleteStatus, InfoCombineStateEnum.HEAD_IMG_COMPLETE.getIndex())) {
            infoCompleteValue += 2;
        }
        if (BitOperatorUtil.getBitAsBoolean(infoCompleteStatus, InfoCombineStateEnum.NICKNAME_COMPLETE.getIndex())) {
            infoCompleteValue ++;
        }
        if (BitOperatorUtil.getBitAsBoolean(infoCompleteStatus, InfoCombineStateEnum.SEX_COMPLETE.getIndex())) {
            infoCompleteValue ++;
        }
        if (BitOperatorUtil.getBitAsBoolean(infoCompleteStatus, InfoCombineStateEnum.BIRTHDAY_COMPLETE.getIndex())) {
            infoCompleteValue ++;
        }
        if (BitOperatorUtil.getBitAsBoolean(infoCompleteStatus, InfoCombineStateEnum.HOMETOWN_COMPLETE.getIndex())) {
            infoCompleteValue ++;
        }
        if (BitOperatorUtil.getBitAsBoolean(infoCompleteStatus, InfoCombineStateEnum.RELATION_SHIP_COMPLETE.getIndex())) {
            infoCompleteValue ++;
        }
        if (BitOperatorUtil.getBitAsBoolean(infoCompleteStatus, InfoCombineStateEnum.JOB_COMPLETE.getIndex())) {
            infoCompleteValue ++;
        }
        if (BitOperatorUtil.getBitAsBoolean(infoCompleteStatus, InfoCombineStateEnum.PERSONAL_PROFILE_COMPLETE.getIndex())) {
            infoCompleteValue ++;
        }
        if (BitOperatorUtil.getBitAsBoolean(infoCompleteStatus, InfoCombineStateEnum.USER_TAG_COMPLETE.getIndex())) {
            infoCompleteValue += 2;
        }
        if (BitOperatorUtil.getBitAsBoolean(infoCompleteStatus, InfoCombineStateEnum.PHONE_COMPLETE.getIndex())) {
            infoCompleteValue += 2;
        }
        return infoCompleteValue;
    }

    /**
     * 计算个人资料的完善度
     * 已完成项/总数（暂时为11）
     * @param infoCompleteStatus
     * @return
     */
    public static int getInfoCompletePercent(Long infoCompleteStatus){
        int infoCompleteNum = InfoCombineStateEnum.values().length;
        int infoCompleteStatusNum = getInfoCompleteStatus(infoCompleteStatus);
        return infoCompleteStatusNum * 100 / infoCompleteNum;
    }

}
