/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service;

import com.bxm.localnews.merchant.common.constant.MerchantGoodsEnum;
import com.bxm.localnews.merchant.integration.AbstractPushService;
import com.bxm.localnews.merchant.security.facade.vo.MerchantMemberVo;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodsVo;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import java.util.Objects;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class PushIntegrationService
extends AbstractPushService {
    public void pushBossWeekReport(Long merchantId, Long userId, String title, String content) {
        MerchantInfo merchantInfo = new MerchantInfo();
        merchantInfo.setId(merchantId);
        merchantInfo.setUserId(userId);
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        info.setProtocol(this.getBossAddress(merchantInfo));
        this.createMsg(userId, title, content, info);
    }

    public void pushBossEveryDayManagement(Long merchantId, Long userId, String title, String content) {
        MerchantInfo merchantInfo = new MerchantInfo();
        merchantInfo.setId(merchantId);
        merchantInfo.setUserId(userId);
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        info.setProtocol(this.getBossMerchantAddress(merchantInfo));
        this.createMsg(userId, title, content, info);
    }

    public void pushEmployeeWeekReport(Long merchantId, Long userId, String title, String content) {
        MerchantMemberVo merchantMemberVo = new MerchantMemberVo();
        merchantMemberVo.setMerchantId(merchantId);
        merchantMemberVo.setUserId(userId);
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        info.setProtocol(this.getEmployeeAddress(merchantMemberVo.getMerchantId(), merchantMemberVo.getUserId()));
        this.createMsg(userId, title, content, info);
    }

    public void pushShareByOrderReport(Long merchantId, Long userId, Integer typeEnum) {
        String title = "\u5e7f\u544a\u5e26\u6765\u4e00\u4e2a\u65b0\u7684\u8ba2\u5355";
        String content = "\u7528\u6237\u901a\u8fc7\u5e16\u5b50\u5e7f\u544a\u63d0\u4ea4\u4e86\u4e00\u7b14\u8ba2\u5355\uff0c\u73b0\u5728\u53bb\u67e5\u770b";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        if (Objects.equals(typeEnum, 0)) {
            MerchantInfo merchantInfo = new MerchantInfo();
            merchantInfo.setId(merchantId);
            merchantInfo.setUserId(userId);
            info.setProtocol(this.getBossAddress(merchantInfo));
        } else {
            MerchantMemberVo merchantMemberVo = new MerchantMemberVo();
            merchantMemberVo.setMerchantId(merchantId);
            merchantMemberVo.setUserId(userId);
            info.setProtocol(this.getEmployeeAddress(merchantMemberVo.getMerchantId(), merchantMemberVo.getUserId()));
        }
        this.createMsg(userId, title, content, info);
    }

    public void pushShareByClickReport(MerchantMemberVo merchantMemberVo) {
        String title = "\u6709\u7528\u6237\u5bf9\u4f60\u7684\u5e97\u94fa\u611f\u5174\u8da3\uff0c\u73b0\u5728\u53bb\u67e5\u770b";
        String content = "\u53d1\u73b0\u65b0\u7684\u5ba2\u6237\u7ebf\u7d22";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        if (Objects.equals(merchantMemberVo.getRole(), 0)) {
            MerchantInfo merchantInfo = new MerchantInfo();
            merchantInfo.setId(merchantMemberVo.getMerchantId());
            merchantInfo.setUserId(merchantMemberVo.getUserId());
            info.setProtocol(this.getBossAddress(merchantInfo));
        } else {
            info.setProtocol(this.getEmployeeAddress(merchantMemberVo.getMerchantId(), merchantMemberVo.getUserId()));
        }
        this.createMsg(merchantMemberVo.getUserId(), title, content, info);
    }

    @Async
    public void pushGoodsMsg(MerchantGoodsVo merchantGoodsVo, MerchantInfo merchantInfo, MerchantGoodsEnum merchantGoodsEnum, String remark) {
        String title = null;
        String content = null;
        String url = null;
        if (Objects.equals(MerchantGoodsEnum.PUSH_GOODS_LESSTEN, merchantGoodsEnum)) {
            title = "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3";
            content = "\u60a8\u7684\u5546\u54c1" + merchantGoodsVo.getName() + "\u5e93\u5b58\u4e0d\u8db3\u4e86\uff0c\u8d76\u5feb\u53bb\u6dfb\u52a0\u5546\u54c1\u5e93\u5b58\u5427~";
            url = this.getGoodsBossAddress(merchantInfo, MerchantGoodsEnum.PAGE_GOODS_SALEIN);
        } else if (Objects.equals(MerchantGoodsEnum.PUSH_GOODS_SELLOUT, merchantGoodsEnum)) {
            title = "\u5546\u54c1\u552e\u7f44";
            content = "\u60a8\u7684\u5546\u54c1" + merchantGoodsVo.getName() + "\u5df2\u552e\u7f44\uff0c\u8d76\u5feb\u53bb\u6dfb\u52a0\u5546\u54c1\u5e93\u5b58\u5427~";
            url = this.getGoodsBossAddress(merchantInfo, MerchantGoodsEnum.PAGE_GOODS_SALEOUT);
        } else if (Objects.equals(MerchantGoodsEnum.AUDIT_GOODS_SUCCESS, merchantGoodsEnum)) {
            title = "\u5546\u54c1\u5ba1\u6838\u901a\u8fc7";
            content = "\u60a8\u521b\u5efa\u7684\u5546\u54c1" + merchantGoodsVo.getName() + "\u5df2\u5ba1\u6838\u901a\u8fc7\uff0c\u8f6c\u53d1\u81f3\u5fae\u4fe1\u8ba9\u66f4\u591a\u4eba\u53c2\u4e0e\u8d2d\u4e70\u54e6~";
            url = this.getGoodsBossAddress(merchantInfo, MerchantGoodsEnum.PAGE_GOODS_SALEIN);
        } else if (Objects.equals(MerchantGoodsEnum.AUDIT_GOODS_FAIL, merchantGoodsEnum)) {
            title = "\u5546\u54c1\u5ba1\u6838\u5931\u8d25";
            content = "\u60a8\u521b\u5efa\u7684\u5546\u54c1" + merchantGoodsVo.getName() + "\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u539f\u56e0\u4e3a" + remark + "\uff0c\u8bf7\u53ca\u65f6\u4fee\u6539~";
            url = this.getGoodsBossAddress(merchantInfo, MerchantGoodsEnum.PAGE_GOODS_AUDIT);
        }
        PushMessage pushMessage = this.pushMerchantMember(merchantInfo.getUserId(), url, title, content);
        this.messageSender.sendPushMessage(pushMessage);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("pushMessage : {}", (Object)pushMessage);
        }
    }
}

