/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.account.add;

import com.bxm.localnews.merchant.common.enums.MerchantAccountTypeEnum;
import com.bxm.localnews.merchant.common.properties.MerchantProAccountProperties;
import com.bxm.localnews.merchant.dto.account.MerchantAccountInfoDTO;
import com.bxm.localnews.merchant.entity.MerchantUserPromotionAccountEntity;
import com.bxm.localnews.merchant.service.account.AbstractUserProAccount;
import com.bxm.localnews.merchant.service.promote.MerchantUserProAccountService;
import com.bxm.localnews.merchant.vo.MerchantUserAccountVO;
import com.bxm.newidea.component.vo.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.RetryException;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractAddProAccount
extends AbstractUserProAccount {
    private static final Logger log = LoggerFactory.getLogger(AbstractAddProAccount.class);
    @Autowired
    private MerchantUserProAccountService merchantUserProAccountService;
    @Autowired
    protected MerchantProAccountProperties merchantProAccountProperties;

    @Override
    protected Boolean checkAmount(MerchantAccountInfoDTO merchantAccountInfoDTO) {
        this.setAmount(merchantAccountInfoDTO);
        MerchantUserAccountVO userAccountVO = this.merchantUserProAccountService.getUserProAccount(merchantAccountInfoDTO.getMerchantId());
        if (userAccountVO.getTotalProCash().add(merchantAccountInfoDTO.getAmount()).compareTo(this.merchantProAccountProperties.getMaxLimit()) > 0) {
            if (userAccountVO.getTotalProCash().compareTo(this.merchantProAccountProperties.getMaxLimit()) < 0) {
                merchantAccountInfoDTO.setAmount(this.merchantProAccountProperties.getMaxLimit().subtract(userAccountVO.getTotalCash()));
            } else {
                log.info("\u7528\u6237[{}]\u5f53\u524d\u7684\u63a8\u5e7f\u91d1[{}],\u63a8\u5e7f\u91d1\u8d85\u8fc7\u6700\u9ad8\u9650\u5236[{}],\uff0c\u6240\u4ee5\u4e0d\u518d\u589e\u52a0~", new Object[]{merchantAccountInfoDTO.getMerchantId(), userAccountVO.getTotalProCash(), this.merchantProAccountProperties.getMaxLimit()});
                return false;
            }
        }
        return true;
    }

    @Override
    protected Message preCheck(MerchantAccountInfoDTO merchantAccountInfoDTO) {
        return Message.build((boolean)true);
    }

    @Override
    protected void changeAccount(MerchantAccountInfoDTO merchantAccountInfoDTO) {
        if (this.addAccount(merchantAccountInfoDTO).booleanValue()) {
            Message.build((boolean)true);
            return;
        }
        throw new RetryException("\u91d1\u989d\u589e\u52a0\u5931\u8d25\uff0c\u8bf7\u6c42\u91cd\u8bd5");
    }

    private Boolean addAccount(MerchantAccountInfoDTO merchantAccountInfoDTO) {
        MerchantUserAccountVO userAccountVO = this.merchantUserProAccountService.getUserProAccount(merchantAccountInfoDTO.getMerchantId());
        MerchantUserPromotionAccountEntity promotionAccountEntity = new MerchantUserPromotionAccountEntity();
        promotionAccountEntity.setAblePromotionCash(merchantAccountInfoDTO.getAmount());
        promotionAccountEntity.setVersion(userAccountVO.getVersionProCash());
        promotionAccountEntity.setMerchantId(merchantAccountInfoDTO.getMerchantId());
        Integer value = this.merchantUserProAccountService.addProAccount(promotionAccountEntity);
        return value > 0;
    }

    @Override
    protected abstract MerchantAccountTypeEnum getType();

    protected abstract void setAmount(MerchantAccountInfoDTO var1);
}

